/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import java.io.IOException;

public class UnixAoutStringTable {
    private final BinaryReader reader;
    private final long fileOffset;

    public UnixAoutStringTable(BinaryReader reader, long fileOffset, long fileSize) {
        this.reader = reader;
        this.fileOffset = fileOffset;
    }

    public String readString(long stringOffset) {
        if (this.fileOffset < 0L) {
            return null;
        }
        try {
            return this.reader.readUtf8String(this.fileOffset + stringOffset).trim();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void markup(Program program, MemoryBlock block) throws CodeUnitInsertionException {
        Listing listing = program.getListing();
        Address address = block.getStart();
        listing.createData(address, StructConverter.DWORD);
        int strlen = 4;
        while (address.getOffset() + (long)strlen < block.getEnd().getOffset()) {
            address = address.add((long)strlen);
            Data str = listing.createData(address, (DataType)TerminatedStringDataType.dataType, -1);
            strlen = str.getLength();
        }
    }
}

