/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.InvalidInputException;

public class SetVariableDataTypeCmd
implements Command<Program> {
    private final Address fnEntry;
    private final String varName;
    private final DataType dataType;
    private final SourceType source;
    private final boolean align;
    private final boolean force;
    private boolean isParm;
    private String status;

    public SetVariableDataTypeCmd(Variable var, DataType dataType, SourceType source) {
        this(var.getFunction().getEntryPoint(), var.getName(), dataType, source);
    }

    public SetVariableDataTypeCmd(Address fnEntry, String varName, DataType dataType, SourceType source) {
        this(fnEntry, varName, dataType, false, true, source);
    }

    public SetVariableDataTypeCmd(Address fnEntry, String varName, DataType dataType, boolean align, boolean force, SourceType source) {
        this.fnEntry = fnEntry;
        this.varName = varName;
        this.dataType = dataType;
        this.align = align;
        this.force = force;
        this.source = source;
    }

    public String getName() {
        return "Set " + (this.isParm ? "Parameter" : "Variable") + " Data Type";
    }

    public boolean applyTo(Program program) {
        Function f = program.getFunctionManager().getFunctionAt(this.fnEntry);
        if (f == null) {
            this.status = "Function not found";
            return false;
        }
        Symbol s = program.getSymbolTable().getParameterSymbol(this.varName, (Namespace)f);
        if (s == null) {
            s = program.getSymbolTable().getLocalVariableSymbol(this.varName, (Namespace)f);
        }
        if (s == null) {
            this.status = "Variable not found";
            return false;
        }
        DataType dt = this.dataType;
        if (this.dataType instanceof FunctionDefinition || this.dataType instanceof TypeDef && ((TypeDef)this.dataType).getDataType() instanceof FunctionDefinition) {
            dt = new PointerDataType(this.dataType);
        }
        Variable var = (Variable)s.getObject();
        this.isParm = var instanceof Parameter;
        try {
            var.setDataType(dt, this.align, this.force, this.source);
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }
}

