/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class VarargsFilter
implements QualifierFilter {
    private int firstPos;
    private int lastPos;

    public VarargsFilter() {
        this.firstPos = Integer.MIN_VALUE;
        this.lastPos = Integer.MAX_VALUE;
    }

    public VarargsFilter(int first, int last) {
        this.firstPos = first;
        this.lastPos = last;
    }

    @Override
    public QualifierFilter clone() {
        return new VarargsFilter(this.firstPos, this.lastPos);
    }

    @Override
    public boolean isEquivalent(QualifierFilter op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        VarargsFilter otherFilter = (VarargsFilter)op;
        return this.firstPos == otherFilter.firstPos && this.lastPos == otherFilter.lastPos;
    }

    @Override
    public boolean filter(PrototypePieces proto, int pos) {
        if (proto.firstVarArgSlot < 0) {
            return false;
        }
        return (pos -= proto.firstVarArgSlot) >= this.firstPos && pos <= this.lastPos;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_VARARGS);
        if (this.firstPos != Integer.MIN_VALUE) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_FIRST, this.firstPos);
        }
        if (this.lastPos != Integer.MAX_VALUE) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_LAST, this.lastPos);
        }
        encoder.closeElement(ElementId.ELEM_VARARGS);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        String lastPosString;
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_VARARGS.name()});
        String firstPosString = elem.getAttribute(AttributeId.ATTRIB_FIRST.name());
        if (firstPosString != null) {
            this.firstPos = SpecXmlUtils.decodeInt((String)firstPosString);
        }
        if ((lastPosString = elem.getAttribute(AttributeId.ATTRIB_LAST.name())) != null) {
            this.lastPos = SpecXmlUtils.decodeInt((String)lastPosString);
        }
        parser.end(elem);
    }
}

