/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.SyntheticLV;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unaligned {
    private static final Logger log = LoggerFactory.getLogger(Unaligned.class);

    public static <V> void centerPoints(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction, int horizontalOffset, int verticalOffset) {
        HashMap<Integer, Integer> rowWidthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> rowMaxHeightMap = new HashMap<Integer, Integer>();
        int layerIndex = 0;
        for (LV<V>[] layer : layers) {
            int width = horizontalOffset;
            int maxHeight = 0;
            for (LV<V> sugiyamaVertex : layer) {
                if (!(sugiyamaVertex instanceof SyntheticLV)) {
                    Rectangle bounds = vertexShapeFunction.apply(sugiyamaVertex.getVertex());
                    width = (int)((double)width + (bounds.width + (double)horizontalOffset));
                    maxHeight = Math.max(maxHeight, (int)bounds.height);
                    continue;
                }
                width += horizontalOffset;
            }
            rowWidthMap.put(layerIndex, width);
            rowMaxHeightMap.put(layerIndex, maxHeight);
            ++layerIndex;
        }
        int widestRowWidth = rowWidthMap.values().stream().mapToInt(v -> v).max().getAsInt();
        int x = 0;
        int y = verticalOffset;
        layerIndex = 0;
        if (log.isTraceEnabled()) {
            log.trace("layerMaxHeights {}", rowMaxHeightMap);
        }
        for (LV<V>[] layer : layers) {
            int previousVertexWidth = 0;
            x += (widestRowWidth - (Integer)rowWidthMap.get(layerIndex)) / 2;
            y += (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            if (layerIndex > 0) {
                y += (Integer)rowMaxHeightMap.get(layerIndex - 1) / 2;
            }
            for (LV<V> sugiyamaVertex : layer) {
                int vertexWidth = 0;
                if (!(sugiyamaVertex instanceof SyntheticLV)) {
                    vertexWidth = (int)vertexShapeFunction.apply(sugiyamaVertex.getVertex()).width;
                }
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                sugiyamaVertex.setPoint(Point.of(x += previousVertexWidth / 2 + vertexWidth / 2 + horizontalOffset, y));
                previousVertexWidth = vertexWidth;
            }
            x = horizontalOffset;
            y += verticalOffset;
            ++layerIndex;
        }
    }

    public static <V> void setPoints(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction, int horizontalOffset, int verticalOffset, Map<LV<V>, Point> vertexPointMap) {
        int layerIndex = 0;
        int x = horizontalOffset;
        int y = verticalOffset;
        layerIndex = 0;
        LV<V>[][] lVArray = layers;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> sugiyamaVertex : layer = lVArray[i]) {
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                sugiyamaVertex.setPoint(Point.of(x += horizontalOffset, y));
                if (!vertexPointMap.containsKey(sugiyamaVertex)) continue;
                vertexPointMap.put(sugiyamaVertex, sugiyamaVertex.getPoint());
            }
            x = horizontalOffset;
            y += verticalOffset;
            ++layerIndex;
        }
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                LV<V> sugiyamaVertex = layers[i][j];
                vertexPointMap.put(sugiyamaVertex, sugiyamaVertex.getPoint());
            }
        }
    }

    public static <V> void setPoints(List<List<LV<V>>> layers, Function<V, Rectangle> vertexShapeFunction, int horizontalOffset, int verticalOffset, Map<LV<V>, Point> vertexPointMap) {
        HashMap<Integer, Integer> rowWidthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> rowMaxHeightMap = new HashMap<Integer, Integer>();
        int layerIndex = 0;
        for (List<LV<V>> layer : layers) {
            int width = horizontalOffset;
            int maxHeight = 0;
            for (LV<V> sugiyamaVertex : layer) {
                if (!(sugiyamaVertex instanceof SyntheticLV)) {
                    Rectangle bounds = vertexShapeFunction.apply(sugiyamaVertex.getVertex());
                    width = (int)((double)width + (bounds.width + (double)horizontalOffset));
                    maxHeight = Math.max(maxHeight, (int)bounds.height);
                    continue;
                }
                width += horizontalOffset;
            }
            rowWidthMap.put(layerIndex, width);
            rowMaxHeightMap.put(layerIndex, maxHeight);
            ++layerIndex;
        }
        int widestRowWidth = rowWidthMap.values().stream().mapToInt(v -> v).max().getAsInt();
        int x = 0;
        int y = verticalOffset;
        layerIndex = 0;
        if (log.isTraceEnabled()) {
            log.trace("layerMaxHeights {}", rowMaxHeightMap);
        }
        for (List<LV<V>> layer : layers) {
            int previousVertexWidth = 0;
            x += (widestRowWidth - (Integer)rowWidthMap.get(layerIndex)) / 2;
            y += (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            if (layerIndex > 0) {
                y += (Integer)rowMaxHeightMap.get(layerIndex - 1) / 2;
            }
            for (LV<V> sugiyamaVertex : layer) {
                int vertexWidth = 0;
                if (!(sugiyamaVertex instanceof SyntheticLV)) {
                    vertexWidth = (int)vertexShapeFunction.apply(sugiyamaVertex.getVertex()).width;
                }
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                sugiyamaVertex.setPoint(Point.of(x += previousVertexWidth / 2 + vertexWidth / 2 + horizontalOffset, y));
                if (vertexPointMap.containsKey(sugiyamaVertex)) {
                    vertexPointMap.put(sugiyamaVertex, sugiyamaVertex.getPoint());
                }
                previousVertexWidth = vertexWidth;
            }
            x = horizontalOffset;
            y += verticalOffset;
            ++layerIndex;
        }
        for (int i = 0; i < layers.size(); ++i) {
            for (int j = 0; j < layers.get(i).size(); ++j) {
                LV<V> sugiyamaVertex = layers.get(i).get(j);
                vertexPointMap.put(sugiyamaVertex, sugiyamaVertex.getPoint());
            }
        }
    }
}

