/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;

public abstract class AbstractVirtualFunctionTablePointerWithOffsetMsType
extends AbstractVirtualFunctionTablePointerMsType {
    protected int offset;

    public AbstractVirtualFunctionTablePointerWithOffsetMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, int skipPaddingSize) throws PdbException {
        super(pdb, reader);
        reader.parseBytes(skipPaddingSize);
        this.pointerTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.offset = reader.parseInt();
    }

    @Override
    public RecordNumber getPointerTypeRecordNumber() {
        return this.pointerTypeRecordNumber;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("VFTablePtr<off=");
        builder.append(this.offset);
        builder.append(">: ");
        builder.append(this.pdb.getTypeRecord(this.pointerTypeRecordNumber));
    }
}

