/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf200;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf700;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Objects;

public class MsfParser {
    public static Msf parse(ByteProvider byteProvider, PdbReaderOptions pdbOptions, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        AbstractMsf msf;
        Objects.requireNonNull(byteProvider, "byteProvider cannot be null");
        Objects.requireNonNull(pdbOptions, "pdbOptions cannot be null");
        Objects.requireNonNull(monitor, "monitor cannot be null");
        if (Msf200.detected(byteProvider)) {
            msf = new Msf200(byteProvider, monitor, pdbOptions);
        } else if (Msf700.detected(byteProvider)) {
            msf = new Msf700(byteProvider, monitor, pdbOptions);
        } else {
            byteProvider.close();
            throw new PdbException("MSF format not detected");
        }
        msf.deserialize();
        return msf;
    }
}

