/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.mvc.FGControllerListener;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.functiongraph.mvc.NavigationHistoryChoices;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public class DefaultFGControllerListener
implements FGControllerListener {
    private FGProvider provider;

    public DefaultFGControllerListener(FGProvider provider) {
        this.provider = provider;
    }

    @Override
    public void dataChanged() {
        this.provider.functionGraphDataChanged();
    }

    @Override
    public void userChangedLocation(ProgramLocation location, boolean vertexChanged) {
        boolean updateHistory = false;
        if (vertexChanged && this.shouldSaveVertexChanges()) {
            this.provider.saveLocationToHistory();
            updateHistory = true;
        }
        this.provider.graphLocationChanged(location);
        if (updateHistory) {
            this.provider.saveLocationToHistory();
        }
    }

    private boolean shouldSaveVertexChanges() {
        FunctionGraphPlugin plugin = this.provider.getPlugin();
        FunctionGraphOptions options = plugin.getFunctionGraphOptions();
        return options.getNavigationHistoryChoice() == NavigationHistoryChoices.VERTEX_CHANGES;
    }

    @Override
    public void userChangedSelection(ProgramSelection selection) {
        this.provider.graphSelectionChanged(selection);
    }

    @Override
    public void userSelectedText(String s) {
        this.provider.setClipboardStringContent(s);
    }

    @Override
    public void userNavigated(ProgramLocation location) {
        this.provider.internalGoTo(location);
    }
}

