/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import docking.ActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.tracermi.RemoteMethodInvocationDialog;
import ghidra.app.plugin.core.debug.service.target.AbstractTarget;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.model.DebuggerSingleObjectPathActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.tracermi.RemoteMethod;
import ghidra.debug.api.tracermi.RemoteMethodRegistry;
import ghidra.debug.api.tracermi.RemoteParameter;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.breakpoint.TraceBreakpointCommon;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceRegister;
import ghidra.trace.model.memory.TraceRegisterContainer;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceEventScope;
import ghidra.trace.model.target.iface.TraceFocusScope;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathMatcher;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceProcess;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TraceRmiTarget
extends AbstractTarget {
    private final TraceRmiConnection connection;
    private final Trace trace;
    private final Matches matches = new Matches();
    private final RequestCaches requestCaches = new DorkedRequestCaches();
    private final Set<TraceBreakpointKind> supportedBreakpointKinds;
    protected static final int BLOCK_BITS = 12;
    protected static final int BLOCK_SIZE = 4096;
    protected static final long BLOCK_MASK = -4096L;

    public TraceRmiTarget(PluginTool tool, TraceRmiConnection connection, Trace trace) {
        super(tool);
        this.connection = connection;
        this.trace = trace;
        this.supportedBreakpointKinds = this.computeSupportedBreakpointKinds();
    }

    public String describe() {
        return "%s in %s at %s (rmi)".formatted(this.getTrace().getDomainFile().getName(), this.connection.getDescription(), this.connection.getRemoteAddress());
    }

    public boolean isValid() {
        return !this.connection.isClosed() && this.connection.isTarget(this.trace);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public long getSnap() {
        try {
            return this.connection.getLastSnapshot(this.trace);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    protected TraceSchedule.ScheduleForm getSupportedTimeFormByMethod(TraceObject obj) {
        KeyPath path = obj.getCanonicalPath();
        MatchedMethod activate = this.matches.getBest(ActivateMatcher.class, path, ActionName.ACTIVATE, ActivateMatcher.makeBySpecificity(obj.getRoot().getSchema(), path));
        if (activate == null) {
            return null;
        }
        if (activate.params.get("time") != null) {
            return TraceSchedule.ScheduleForm.SNAP_ANY_STEPS_OPS;
        }
        if (activate.params.get("snap") != null) {
            return TraceSchedule.ScheduleForm.SNAP_ONLY;
        }
        return null;
    }

    protected TraceSchedule.ScheduleForm getSupportedTimeFormByAttribute(TraceObject obj, long snap) {
        TraceObject eventScope = obj.findSuitableInterface(TraceEventScope.class);
        if (eventScope == null) {
            return null;
        }
        TraceObjectValue timeSupportStr = eventScope.getAttribute(snap, "_time_support");
        if (timeSupportStr == null) {
            return null;
        }
        return TraceSchedule.ScheduleForm.valueOf((String)((String)timeSupportStr.castValue()));
    }

    public TraceSchedule.ScheduleForm getSupportedTimeForm(TraceObject obj, long snap) {
        TraceSchedule.ScheduleForm byMethod = this.getSupportedTimeFormByMethod(obj);
        if (byMethod == null) {
            return null;
        }
        TraceSchedule.ScheduleForm byAttr = this.getSupportedTimeFormByAttribute(obj, snap);
        if (byAttr == null) {
            return null;
        }
        return byMethod.intersect(byAttr);
    }

    public TraceExecutionState getThreadExecutionState(TraceThread thread) {
        return thread.getObject().getExecutionState(this.getSnap());
    }

    public TraceThread getThreadForSuccessor(KeyPath path) {
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        return object.queryCanonicalAncestorsInterface(TraceThread.class).findFirst().orElse(null);
    }

    public TraceStackFrame getStackFrameForSuccessor(KeyPath path) {
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        return object.queryCanonicalAncestorsInterface(TraceStackFrame.class).findFirst().orElse(null);
    }

    protected TraceObject findObject(ActionContext context, Target.ObjectArgumentPolicy policy) {
        if (policy.allowContextObject()) {
            if (context instanceof DebuggerObjectActionContext) {
                TraceObjectValue ov;
                DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
                List values = ctx.getObjectValues();
                if (values.size() == 1 && (ov = (TraceObjectValue)values.get(0)).isObject()) {
                    return ov.getChild();
                }
            } else if (context instanceof DebuggerSingleObjectPathActionContext) {
                DebuggerSingleObjectPathActionContext ctx = (DebuggerSingleObjectPathActionContext)context;
                TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(ctx.getPath());
                if (object != null) {
                    return object;
                }
                object = this.trace.getObjectManager().getObjectsByPath(Lifespan.at((long)this.getSnap()), ctx.getPath()).findAny().orElse(null);
                if (object != null) {
                    return object;
                }
            }
        }
        if (policy.allowCoordsObject()) {
            DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
            if (traceManager == null) {
                return null;
            }
            return traceManager.getCurrentFor(this.trace).getObject();
        }
        return null;
    }

    protected Boolean findBool(ActionName action, ActionContext context, Target.ObjectArgumentPolicy policy) {
        Boolean b;
        Object object;
        if (!Objects.equals(action, ActionName.TOGGLE)) {
            return null;
        }
        TraceObject object2 = this.findObject(context, policy);
        if (object2 == null) {
            return null;
        }
        TraceObjectValue attrEnabled = object2.getAttribute(this.getSnap(), "_enabled");
        boolean enabled = attrEnabled != null && (object = attrEnabled.getValue()) instanceof Boolean && (b = (Boolean)object) != false;
        return !enabled;
    }

    protected Object findArgumentForSchema(ActionName action, ActionContext context, TraceObjectSchema schema, Target.ObjectArgumentPolicy policy) {
        if (schema instanceof PrimitiveTraceObjectSchema) {
            PrimitiveTraceObjectSchema prim = (PrimitiveTraceObjectSchema)schema;
            return switch (prim) {
                case PrimitiveTraceObjectSchema.OBJECT -> this.findObject(context, policy);
                case PrimitiveTraceObjectSchema.ADDRESS -> this.findAddress(context);
                case PrimitiveTraceObjectSchema.RANGE -> this.findRange(context);
                case PrimitiveTraceObjectSchema.BOOL -> this.findBool(action, context, policy);
                default -> null;
            };
        }
        TraceObject object = this.findObject(context, policy);
        if (object == null) {
            return null;
        }
        if (policy.allowSuitableRelative()) {
            return object.findSuitableSchema(schema);
        }
        if (object.getSchema() == schema) {
            return object;
        }
        return null;
    }

    protected Object findArgument(ActionName action, RemoteParameter parameter, ActionContext context, Target.ObjectArgumentPolicy policy) {
        TraceObjectSchema.SchemaName type = parameter.type();
        SchemaContext ctx = this.getSchemaContext();
        if (ctx == null) {
            Msg.trace((Object)((Object)this), (Object)("No root schema, yet: " + String.valueOf(this.trace)));
            return null;
        }
        TraceObjectSchema schema = ctx.getSchemaOrNull(type);
        if (schema == null) {
            Msg.error((Object)((Object)this), (Object)("Schema " + String.valueOf(type) + " not in trace! " + String.valueOf(this.trace)));
            return null;
        }
        Object arg = this.findArgumentForSchema(action, context, schema, policy);
        if (arg != null) {
            return arg;
        }
        if (!parameter.required()) {
            return parameter.getDefaultValue();
        }
        return Missing.MISSING;
    }

    protected Map<String, Object> collectArguments(RemoteMethod method, ActionContext context, Target.ObjectArgumentPolicy policy) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (RemoteParameter param : method.parameters().values()) {
            Object found = this.findArgument(method.action(), param, context, policy);
            if (found == null) continue;
            args.put(param.name(), found);
        }
        return args;
    }

    protected static long computeSpecificity(RemoteMethod method, Map<String, Object> args) {
        long score = 0L;
        for (RemoteParameter param : method.parameters().values()) {
            TraceObjectSchema traceObjectSchema = PrimitiveTraceObjectSchema.MinimalSchemaContext.INSTANCE.getSchemaOrNull(param.type());
            int n = 0;
            score += (long)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTraceObjectSchema.class}, (Object)traceObjectSchema, n)) {
                case 0 -> {
                    PrimitiveTraceObjectSchema prim = (PrimitiveTraceObjectSchema)traceObjectSchema;
                    switch (prim) {
                        case ANY: {
                            yield 0;
                        }
                        case OBJECT: {
                            yield 1;
                        }
                    }
                    yield 2;
                }
                case -1 -> 100;
                default -> 100;
            });
        }
        score *= 1000L;
        for (Object o : args.values()) {
            if (!(o instanceof TraceObject)) continue;
            TraceObject obj = (TraceObject)o;
            score += (long)obj.getCanonicalPath().size();
        }
        return score;
    }

    protected RemoteParameter getFirstObjectParameter(RemoteMethod method) {
        SchemaContext ctx = this.getSchemaContext();
        if (ctx == null) {
            return null;
        }
        return method.parameters().values().stream().filter(p -> TraceObjectInterfaceUtils.isTraceObject((Class)ctx.getSchema(p.type()).getType())).findFirst().orElse(null);
    }

    protected ParamAndObjectArg getFirstObjectArgument(RemoteMethod method, Map<String, Object> args) {
        RemoteParameter firstParam = this.getFirstObjectParameter(method);
        if (firstParam == null) {
            return null;
        }
        Object firstArg = args.get(firstParam.name());
        if (firstArg == null || !(firstArg instanceof TraceObject)) {
            Msg.trace((Object)((Object)this), (Object)("MISSING first argument for " + String.valueOf(method) + "(" + String.valueOf(firstParam) + ")"));
            return new ParamAndObjectArg(firstParam, null);
        }
        TraceObject obj = (TraceObject)firstArg;
        return new ParamAndObjectArg(firstParam, obj);
    }

    private Map<String, Object> promptArgs(RemoteMethod method, Map<String, Object> defaults) {
        Map defs = ValStr.fromPlainMap(defaults);
        RemoteMethodInvocationDialog dialog = new RemoteMethodInvocationDialog(this.tool, this.getSchemaContext(), method.display(), method.okText(), method.icon());
        Map args = dialog.promptArguments(method.parameters(), defs, defs);
        return args == null ? null : ValStr.toPlainMap((Map)args);
    }

    private CompletableFuture<?> invokeMethod(boolean prompt, RemoteMethod method, Map<String, Object> arguments) {
        Map<String, Object> chosenArgs = prompt ? this.promptArgs(method, arguments) : arguments;
        return method.invokeAsync(chosenArgs).thenAccept(result -> {
            DebuggerConsoleService consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
            Class retType = this.getSchemaContext().getSchema(method.retType()).getType();
            if (consoleService != null && retType != Void.class && retType != Object.class) {
                consoleService.log(null, method.name() + " returned " + String.valueOf(result));
            }
        }).toCompletableFuture();
    }

    protected Target.ActionEntry createEntry(RemoteMethod method, ActionContext context, Target.ObjectArgumentPolicy policy) {
        Map<String, Object> args = this.collectArguments(method, context, policy);
        return new TraceRmiActionEntry(method, args);
    }

    protected Map<String, Target.ActionEntry> collectFromMethods(Collection<RemoteMethod> methods, ActionContext context, Target.ObjectArgumentPolicy policy) {
        HashMap<String, Target.ActionEntry> result = new HashMap<String, Target.ActionEntry>();
        for (RemoteMethod m : methods) {
            Target.ActionEntry entry = this.createEntry(m, context, policy);
            result.put(m.name(), entry);
        }
        return result;
    }

    protected boolean isAddressMethod(RemoteMethod method, SchemaContext ctx) {
        return method.parameters().values().stream().filter(p -> {
            TraceObjectSchema schema = ctx.getSchemaOrNull(p.type());
            if (schema == null) {
                Msg.error((Object)((Object)this), (Object)("Method " + String.valueOf(method) + " refers to invalid schema name: " + String.valueOf(p.type())));
                return false;
            }
            return schema.getType() == Address.class;
        }).count() == 1L;
    }

    protected Map<String, Target.ActionEntry> collectAddressActions(ProgramLocationActionContext context) {
        SchemaContext ctx = this.getSchemaContext();
        HashMap<String, Target.ActionEntry> result = new HashMap<String, Target.ActionEntry>();
        for (RemoteMethod m : this.connection.getMethods().all().values()) {
            if (!this.isAddressMethod(m, ctx)) continue;
            result.put(m.name(), this.createEntry(m, (ActionContext)context, Target.ObjectArgumentPolicy.CURRENT_AND_RELATED));
        }
        return result;
    }

    protected Map<String, Target.ActionEntry> collectAllActions(ActionContext context, Target.ObjectArgumentPolicy policy) {
        return this.collectFromMethods(this.connection.getMethods().all().values(), context, policy);
    }

    protected Map<String, Target.ActionEntry> collectByName(ActionName name, ActionContext context, Target.ObjectArgumentPolicy policy) {
        return this.collectFromMethods(this.connection.getMethods().getByAction(name), context, policy);
    }

    public Map<String, Target.ActionEntry> collectActions(ActionName name, ActionContext context, Target.ObjectArgumentPolicy policy) {
        if (name == null) {
            if (context instanceof ProgramLocationActionContext) {
                ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
                return this.collectAddressActions(ctx);
            }
            return this.collectAllActions(context, policy);
        }
        return this.collectByName(name, context, policy);
    }

    public boolean isSupportsFocus() {
        TraceObjectSchema schema = this.trace.getObjectManager().getRootSchema();
        if (schema == null) {
            Msg.trace((Object)((Object)this), (Object)"Checked for focus support before root schema is available");
            return false;
        }
        return schema.getInterfaces().contains(TraceFocusScope.class) && !this.connection.getMethods().getByAction(ActionName.ACTIVATE).isEmpty();
    }

    public KeyPath getFocus() {
        TraceObjectValue focusVal = this.trace.getObjectManager().getRootObject().getAttribute(this.getSnap(), "_focus");
        if (focusVal == null || !focusVal.isObject()) {
            return null;
        }
        return focusVal.getChild().getCanonicalPath();
    }

    protected static boolean typeMatches(RemoteMethod method, RemoteParameter param, TraceObjectSchema rootSchema, KeyPath path, Class<?> type) {
        SchemaContext ctx = rootSchema.getContext();
        TraceObjectSchema sch = ctx.getSchemaOrNull(param.type());
        if (sch == null) {
            throw new RuntimeException("The parameter '%s' of method '%s' refers to a non-existent schema '%s'".formatted(param.name(), method.name(), param.type()));
        }
        if (type == TraceObject.class) {
            return sch == PrimitiveTraceObjectSchema.OBJECT;
        }
        if (TraceObjectInterface.class.isAssignableFrom(type)) {
            if (path == null) {
                return sch.getInterfaces().contains(type);
            }
            KeyPath found = rootSchema.searchForSuitable(type.asSubclass(TraceObjectInterface.class), path);
            if (found == null) {
                return false;
            }
            return sch == rootSchema.getSuccessorSchema(path);
        }
        return sch.getType() == type;
    }

    protected static <T extends MethodMatcher> List<T> matchers(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.sort(Comparator.comparing(MethodMatcher::score).reversed());
        if (result.isEmpty()) {
            throw new AssertionError((Object)"empty matchers list?");
        }
        int prevScore = ((MethodMatcher)result.get(0)).score();
        for (int i = 1; i < result.size(); ++i) {
            int curScore = ((MethodMatcher)result.get(i)).score();
            if (prevScore <= curScore) {
                throw new AssertionError((Object)("duplicate scores: " + curScore));
            }
        }
        return List.copyOf(result);
    }

    @SafeVarargs
    protected static <T extends MethodMatcher> List<T> matchers(T ... list) {
        return TraceRmiTarget.matchers(Arrays.asList(list));
    }

    public CompletableFuture<String> executeAsync(String command, boolean toString) {
        MatchedMethod execute = this.matches.getBest(ExecuteMatcher.class, null, ActionName.EXECUTE, ExecuteMatcher.ALL);
        if (execute == null) {
            return CompletableFuture.failedFuture(new NoSuchElementException());
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(execute.params.get("command").name(), command);
        args.put(execute.params.get("toString").name(), toString);
        return execute.method.invokeAsync(args).toCompletableFuture().thenApply(v -> (String)v);
    }

    public CompletableFuture<Void> activateAsync(DebuggerCoordinates prev, DebuggerCoordinates coords) {
        RemoteParameter paramSnap;
        TraceObject object;
        boolean timeNeq;
        boolean bl = timeNeq = !Objects.equals(prev.getTime(), coords.getTime());
        if (timeNeq) {
            this.requestCaches.invalidate();
        }
        if ((object = coords.getObject()) == null) {
            return AsyncUtils.nil();
        }
        KeyPath path = object.getCanonicalPath();
        MatchedMethod activate = this.matches.getBest(ActivateMatcher.class, path, ActionName.ACTIVATE, ActivateMatcher.makeBySpecificity(object.getRoot().getSchema(), path));
        if (activate == null) {
            return AsyncUtils.nil();
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        RemoteParameter paramFocus = activate.params.get("focus");
        args.put(paramFocus.name(), object.findSuitableSchema(this.getSchemaContext().getSchema(paramFocus.type())));
        RemoteParameter paramTime = activate.params.get("time");
        if (paramTime != null && (paramTime.required() || timeNeq)) {
            args.put(paramTime.name(), coords.getTime().toString());
        }
        if ((paramSnap = activate.params.get("snap")) != null && (paramSnap.required() || timeNeq)) {
            args.put(paramSnap.name(), coords.getSnap());
        }
        return activate.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    public CompletableFuture<Void> invalidateMemoryCachesAsync() {
        this.requestCaches.invalidateMemory();
        return AsyncUtils.nil();
    }

    protected static AddressSetView quantize(AddressSetView set) {
        AddressSet result = new AddressSet();
        for (AddressRange range : set) {
            AddressSpace space = range.getAddressSpace();
            Address min = space.getAddress(range.getMinAddress().getOffset() & 0xFFFFFFFFFFFFF000L);
            Address max = space.getAddress(range.getMaxAddress().getOffset() | 0xFFFL);
            result.add((AddressRange)new AddressRangeImpl(min, max));
        }
        return result;
    }

    protected SchemaContext getSchemaContext() {
        TraceObjectSchema rootSchema = this.trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return null;
        }
        return rootSchema.getContext();
    }

    protected TraceObject getProcessForSpace(AddressSpace space) {
        List processes = this.trace.getObjectManager().queryAllInterface(Lifespan.at((long)this.getSnap()), TraceProcess.class).toList();
        if (processes.size() == 1) {
            return ((TraceProcess)processes.get(0)).getObject();
        }
        if (processes.isEmpty()) {
            return null;
        }
        Iterator iterator = this.trace.getMemoryManager().getRegionsIntersecting(Lifespan.at((long)this.getSnap()), (AddressRange)new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress())).iterator();
        if (iterator.hasNext()) {
            TraceMemoryRegion region = (TraceMemoryRegion)iterator.next();
            TraceObject obj = region.getObject();
            return obj.findCanonicalAncestorsInterface(TraceProcess.class).findFirst().orElse(null);
        }
        return null;
    }

    public CompletableFuture<Void> readMemoryAsync(AddressSetView set, TaskMonitor monitor) {
        MatchedMethod readMem = this.matches.getBest(ReadMemMatcher.class, null, ActionName.READ_MEM, ReadMemMatcher.ALL);
        if (readMem == null) {
            return AsyncUtils.nil();
        }
        RemoteParameter paramRange = readMem.params.get("range");
        RemoteParameter paramProcess = readMem.params.get("process");
        HashMap procsBySpace = paramProcess != null ? new HashMap() : null;
        int total = 0;
        AddressSetView quantized = TraceRmiTarget.quantize(set);
        for (AddressRange r2 : quantized) {
            total = (int)((long)total + Long.divideUnsigned(r2.getLength() + 4096L - 1L, 4096L));
        }
        monitor.initialize((long)total);
        monitor.setMessage("Reading memory");
        return quantized.stream().flatMap(r -> {
            if (r.getAddressSpace().isRegisterSpace()) {
                Msg.warn((Object)((Object)this), (Object)("Request to read registers via readMemory: " + String.valueOf(r) + ". Ignoring."));
                return Stream.of(new AddressRange[0]);
            }
            return new AddressRangeChunker(r, 4096).stream();
        }).reduce(AsyncUtils.nil(), (f, blk) -> {
            Map args;
            if (monitor.isCancelled()) {
                return f;
            }
            if (paramProcess != null) {
                TraceObject process = procsBySpace.computeIfAbsent(blk.getAddressSpace(), this::getProcessForSpace);
                if (process == null) {
                    return f;
                }
                args = Map.ofEntries(Map.entry(paramProcess.name(), process), Map.entry(paramRange.name(), blk));
            } else {
                args = Map.ofEntries(Map.entry(paramRange.name(), blk));
            }
            return ((CompletableFuture)f.thenComposeAsync(__ -> {
                if (monitor.isCancelled()) {
                    return AsyncUtils.nil();
                }
                monitor.incrementProgress(1L);
                return this.requestCaches.readBlock(blk.getMinAddress(), readMem.method, args);
            }, (Executor)AsyncUtils.FRAMEWORK_EXECUTOR)).exceptionally(e -> {
                Msg.error((Object)((Object)this), (Object)("Could not read " + String.valueOf(blk) + ": " + String.valueOf(e)));
                return null;
            });
        }, (f1, f2) -> {
            throw new AssertionError((Object)"Should be sequential");
        });
    }

    public CompletableFuture<Void> writeMemoryAsync(Address address, byte[] data) {
        MatchedMethod writeMem = this.matches.getBest(WriteMemMatcher.class, null, ActionName.WRITE_MEM, WriteMemMatcher.ALL);
        if (writeMem == null) {
            return AsyncUtils.nil();
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(writeMem.params.get("start").name(), address);
        args.put(writeMem.params.get("data").name(), data);
        RemoteParameter paramProcess = writeMem.params.get("process");
        if (paramProcess != null) {
            TraceObject process = this.getProcessForSpace(address.getAddressSpace());
            if (process == null) {
                throw new IllegalStateException("Cannot find process containing " + String.valueOf(address));
            }
            args.put(paramProcess.name(), process);
        }
        return writeMem.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    public CompletableFuture<Void> readRegistersAsync(TracePlatform platform, TraceThread thread, int frame, Set<Register> registers) {
        MatchedMethod readRegs = this.matches.getBest(ReadRegsMatcher.class, null, ActionName.REFRESH, ReadRegsMatcher.ALL);
        if (readRegs == null) {
            return AsyncUtils.nil();
        }
        TraceObject container = thread.getObject().findRegisterContainer(frame);
        if (container == null) {
            Msg.error((Object)((Object)this), (Object)("Cannot find register container for thread,frame: " + String.valueOf(thread) + "," + frame));
            return AsyncUtils.nil();
        }
        RemoteParameter paramContainer = readRegs.params.get("container");
        if (paramContainer != null) {
            return this.requestCaches.readRegs(container, readRegs.method, Map.of(paramContainer.name(), container));
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (Register r2 : registers) {
            String lower = r2.getName().toLowerCase();
            keys.add(lower);
            keys.add("[" + lower + "]");
        }
        Set regs = container.findSuccessorsInterface(Lifespan.at((long)this.getSnap()), TraceRegister.class, true).filter(p -> keys.contains(p.getLastEntry().getEntryKey().toLowerCase())).map(r -> r.getDestination(null)).collect(Collectors.toSet());
        RemoteParameter paramRegister = readRegs.params.get("register");
        if (paramRegister != null) {
            AsyncFence fence = new AsyncFence();
            regs.stream().forEach(r -> fence.include(this.requestCaches.readRegs((TraceObject)r, readRegs.method, (Map<String, Object>)Map.of(paramRegister.name(), r))));
            return fence.ready();
        }
        throw new AssertionError();
    }

    protected TraceObjectValue tryRegister(TraceObject container, PathFilter filter, String name) {
        PathMatcher applied = filter.isNone() ? PathMatcher.any((PathFilter[])new PathFilter[]{new PathPattern(KeyPath.ROOT.key(name)), new PathPattern(KeyPath.ROOT.key(name.toLowerCase())), new PathPattern(KeyPath.ROOT.key(name.toUpperCase())), new PathPattern(KeyPath.ROOT.index(name)), new PathPattern(KeyPath.ROOT.index(name.toLowerCase())), new PathPattern(KeyPath.ROOT.index(name.toUpperCase()))}) : PathMatcher.any((PathFilter[])new PathFilter[]{filter.applyKeys(PathFilter.Align.RIGHT, new String[]{name}), filter.applyKeys(PathFilter.Align.RIGHT, new String[]{name.toLowerCase()}), filter.applyKeys(PathFilter.Align.RIGHT, new String[]{name.toUpperCase()})});
        TraceObjectValPath regValPath = container.getSuccessors(Lifespan.at((long)this.getSnap()), (PathFilter)applied).findFirst().orElse(null);
        if (regValPath == null) {
            Msg.error((Object)((Object)this), (Object)("Cannot find register object/value for " + name + " in " + String.valueOf(container)));
            return null;
        }
        return regValPath.getLastEntry();
    }

    protected FoundRegister findRegister(TraceObject container, PathFilter filter, Register register) {
        TraceObjectValue val = this.tryRegister(container, filter, register.getName());
        if (val != null) {
            return new FoundRegister(register, val);
        }
        for (String alias : register.getAliases()) {
            val = this.tryRegister(container, filter, alias);
            if (val == null) continue;
            return new FoundRegister(register, val);
        }
        Register parent = register.getParentRegister();
        if (parent == null) {
            return null;
        }
        return this.findRegister(container, filter, parent);
    }

    protected FoundRegister findRegister(TraceThread thread, int frame, Register register) {
        TraceObject container = thread.getObject().findRegisterContainer(frame);
        if (container == null) {
            Msg.error((Object)((Object)this), (Object)("No register container for thread=" + String.valueOf(thread) + ",frame=" + frame));
            return null;
        }
        PathFilter filter = container.getSchema().searchFor(TraceRegister.class, true);
        return this.findRegister(container, filter, register);
    }

    protected byte[] getBytes(RegisterValue rv) {
        return Utils.bigIntegerToBytes((BigInteger)rv.getUnsignedValue(), (int)rv.getRegister().getMinimumByteSize(), (boolean)true);
    }

    protected RegisterValue retrieveAndCombine(TracePlatform platform, TraceThread thread, int frameLevel, FoundRegister found, RegisterValue value) {
        TraceMemorySpace regSpace = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, frameLevel, false);
        if (regSpace == null) {
            return new RegisterValue(found.register, BigInteger.ZERO).combineValues(value);
        }
        return regSpace.getValue(platform, this.getSnap(), found.register).combineValues(value);
    }

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform platform, TraceThread thread, int frameLevel, RegisterValue value) {
        MatchedMethod writeReg = this.matches.getBest(WriteRegMatcher.class, null, ActionName.WRITE_REG, WriteRegMatcher.ALL);
        if (writeReg == null) {
            return AsyncUtils.nil();
        }
        FoundRegister found = this.findRegister(thread, frameLevel, value.getRegister());
        if (found == null) {
            Msg.warn((Object)((Object)this), (Object)("Could not find register " + String.valueOf(value.getRegister()) + " in object model."));
        } else if (found.register != value.getRegister()) {
            value = this.retrieveAndCombine(platform, thread, frameLevel, found, value);
        }
        RemoteParameter paramThread = writeReg.params.get("thread");
        if (paramThread != null) {
            return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(paramThread.name(), thread.getObject()), Map.entry(writeReg.params.get("name").name(), found.name()), Map.entry(writeReg.params.get("value").name(), this.getBytes(value)))).toCompletableFuture().thenApply(__ -> null);
        }
        RemoteParameter paramFrame = writeReg.params.get("frame");
        if (paramFrame != null) {
            TraceStack stack = this.trace.getStackManager().getLatestStack(thread, this.getSnap());
            TraceStackFrame frame = stack.getFrame(this.getSnap(), frameLevel, false);
            return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(paramFrame.name(), frame.getObject()), Map.entry(writeReg.params.get("name").name(), found.name()), Map.entry(writeReg.params.get("value").name(), this.getBytes(value)))).toCompletableFuture().thenApply(__ -> null);
        }
        if (found == null || !found.value.isObject()) {
            return AsyncUtils.nil();
        }
        return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(writeReg.params.get("register").name(), found.value.getChild()), Map.entry(writeReg.params.get("value").name(), this.getBytes(value)))).toCompletableFuture().thenApply(__ -> null);
    }

    protected boolean isMemorySpaceValid(TracePlatform platform, AddressSpace space) {
        return platform.getAddressFactory().getAddressSpace(space.getSpaceID()) == space;
    }

    protected boolean isRegisterValid(TracePlatform platform, TraceThread thread, int frame, Address address, int length) {
        if (!this.isMemorySpaceValid(platform, address.getAddressSpace())) {
            return false;
        }
        Register register = platform.getLanguage().getRegister(address.getPhysicalAddress(), length);
        if (register == null) {
            return false;
        }
        FoundRegister found = this.findRegister(thread, frame, register);
        return found != null;
    }

    public boolean isVariableExists(TracePlatform platform, TraceThread thread, int frame, Address address, int length) {
        if (address.isMemoryAddress()) {
            return this.isMemorySpaceValid(platform, address.getAddressSpace());
        }
        if (address.isRegisterAddress()) {
            return this.isRegisterValid(platform, thread, frame, address, length);
        }
        return false;
    }

    public CompletableFuture<Void> writeVariableAsync(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        if (address.isMemoryAddress()) {
            return this.writeMemoryAsync(address, data);
        }
        if (address.isRegisterAddress()) {
            return this.writeRegisterAsync(platform, thread, frame, address, data);
        }
        Msg.error((Object)((Object)this), (Object)("Address is neither memory nor register: " + String.valueOf(address)));
        return AsyncUtils.nil();
    }

    protected Address expectSingleAddr(AddressRange range, TraceBreakpointKind kind) {
        Address address = range.getMinAddress();
        if (range.getLength() != 1L) {
            Msg.warn((Object)((Object)this), (Object)("Expected single address for " + String.valueOf(kind) + " breakpoint. Got " + String.valueOf(range) + ". Using " + String.valueOf(address)));
        }
        return address;
    }

    protected void putOptionalBreakArgs(Map<String, Object> args, MatchedMethod brk, String condition, String commands) {
        RemoteParameter paramProc = brk.params.get("process");
        if (paramProc != null) {
            Object proc = this.findArgumentForSchema(null, null, this.getSchemaContext().getSchema(paramProc.type()), Target.ObjectArgumentPolicy.CURRENT_AND_RELATED);
            if (proc == null) {
                Msg.error((Object)((Object)this), (Object)("Cannot find required process argument for " + String.valueOf(brk.method)));
            } else {
                args.put(paramProc.name(), proc);
            }
        }
        if (condition != null && !condition.isBlank()) {
            RemoteParameter paramCond = brk.params.get("condition");
            if (paramCond == null) {
                Msg.error((Object)((Object)this), (Object)("No condition parameter  on " + String.valueOf(brk.method)));
            } else {
                args.put(paramCond.name(), condition);
            }
        }
        if (commands != null && !commands.isBlank()) {
            RemoteParameter paramCmds = brk.params.get("commands");
            if (paramCmds == null) {
                Msg.error((Object)((Object)this), (Object)("No commands parameter on " + String.valueOf(brk.method)));
            } else {
                args.put(paramCmds.name(), commands);
            }
        }
    }

    protected CompletableFuture<Void> doPlaceExecBreakAsync(MatchedMethod breakExec, Address address, String condition, String commands) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(breakExec.params.get("address").name(), address);
        this.putOptionalBreakArgs(args, breakExec, condition, commands);
        return breakExec.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> placeHwExecBreakAsync(Address address, String condition, String commands) {
        MatchedMethod breakHwExec = this.matches.getBest(BreakExecMatcher.class, null, ActionName.BREAK_HW_EXECUTE, BreakExecMatcher.ALL);
        if (breakHwExec == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceExecBreakAsync(breakHwExec, address, condition, commands);
    }

    protected CompletableFuture<Void> placeSwExecBreakAsync(Address address, String condition, String commands) {
        MatchedMethod breakSwExec = this.matches.getBest(BreakExecMatcher.class, null, ActionName.BREAK_SW_EXECUTE, BreakExecMatcher.ALL);
        if (breakSwExec == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceExecBreakAsync(breakSwExec, address, condition, commands);
    }

    protected CompletableFuture<Void> doPlaceAccBreakAsync(MatchedMethod breakAcc, AddressRange range, String condition, String commands) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(breakAcc.params.get("range").name(), range);
        this.putOptionalBreakArgs(args, breakAcc, condition, commands);
        return breakAcc.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> placeReadBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakRead = this.matches.getBest(BreakAccMatcher.class, null, ActionName.BREAK_READ, BreakAccMatcher.ALL);
        if (breakRead == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakRead, range, condition, commands);
    }

    protected CompletableFuture<Void> placeWriteBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakWrite = this.matches.getBest(BreakAccMatcher.class, null, ActionName.BREAK_WRITE, BreakAccMatcher.ALL);
        if (breakWrite == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakWrite, range, condition, commands);
    }

    protected CompletableFuture<Void> placeAccessBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakAccess = this.matches.getBest(BreakAccMatcher.class, null, ActionName.BREAK_ACCESS, BreakAccMatcher.ALL);
        if (breakAccess == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakAccess, range, condition, commands);
    }

    public CompletableFuture<Void> placeBreakpointAsync(AddressRange range, Set<TraceBreakpointKind> kinds, String condition, String commands) {
        Set<TraceBreakpointKind> copyKinds = Set.copyOf(kinds);
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.HW_EXECUTE)) {
            return this.placeHwExecBreakAsync(this.expectSingleAddr(range, TraceBreakpointKind.HW_EXECUTE), condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.SW_EXECUTE)) {
            return this.placeSwExecBreakAsync(this.expectSingleAddr(range, TraceBreakpointKind.SW_EXECUTE), condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.READ)) {
            return this.placeReadBreakAsync(range, condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.WRITE)) {
            return this.placeWriteBreakAsync(range, condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.ACCESS)) {
            return this.placeAccessBreakAsync(range, condition, commands);
        }
        Msg.error((Object)((Object)this), (Object)("Invalid kinds in combination: " + String.valueOf(kinds)));
        return AsyncUtils.nil();
    }

    protected Set<TraceBreakpointKind> computeSupportedBreakpointKinds() {
        HashSet<TraceBreakpointKind> result = new HashSet<TraceBreakpointKind>();
        RemoteMethodRegistry methods = this.connection.getMethods();
        if (!methods.getByAction(ActionName.BREAK_HW_EXECUTE).isEmpty()) {
            result.add(TraceBreakpointKind.HW_EXECUTE);
        }
        if (!methods.getByAction(ActionName.BREAK_SW_EXECUTE).isEmpty()) {
            result.add(TraceBreakpointKind.SW_EXECUTE);
        }
        if (!methods.getByAction(ActionName.BREAK_READ).isEmpty()) {
            result.add(TraceBreakpointKind.READ);
        }
        if (!methods.getByAction(ActionName.BREAK_WRITE).isEmpty()) {
            result.add(TraceBreakpointKind.WRITE);
        }
        if (!methods.getByAction(ActionName.BREAK_ACCESS).isEmpty()) {
            result.add(TraceBreakpointKind.READ);
            result.add(TraceBreakpointKind.WRITE);
        }
        return Set.copyOf(result);
    }

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds() {
        return this.supportedBreakpointKinds;
    }

    public boolean isBreakpointValid(TraceBreakpointLocation breakpoint) {
        long snap = this.getSnap();
        if (breakpoint.getName(snap).endsWith("emu-" + String.valueOf(breakpoint.getMinAddress(snap)))) {
            return false;
        }
        return breakpoint.isValid(snap);
    }

    protected CompletableFuture<Void> deleteBreakpointSpecAsync(TraceBreakpointSpec spec) {
        KeyPath path = spec.getObject().getCanonicalPath();
        MatchedMethod delBreak = this.matches.getBest(DelBreakMatcher.class, path, ActionName.DELETE, DelBreakMatcher.SPEC);
        if (delBreak == null) {
            return AsyncUtils.nil();
        }
        return delBreak.method.invokeAsync(Map.of(delBreak.params.get("specification").name(), spec.getObject())).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> deleteBreakpointLocAsync(TraceBreakpointLocation loc) {
        KeyPath path = loc.getObject().getCanonicalPath();
        MatchedMethod delBreak = this.matches.getBest(DelBreakMatcher.class, path, ActionName.DELETE, DelBreakMatcher.ALL);
        if (delBreak == null) {
            Msg.debug((Object)((Object)this), (Object)"Falling back to delete spec");
            return this.deleteBreakpointSpecAsync(loc.getSpecification());
        }
        RemoteParameter paramLocation = delBreak.params.get("location");
        if (paramLocation != null) {
            return delBreak.method.invokeAsync(Map.of(paramLocation.name(), loc.getObject())).toCompletableFuture().thenApply(__ -> null);
        }
        return this.deleteBreakpointSpecAsync(loc.getSpecification());
    }

    public CompletableFuture<Void> deleteBreakpointAsync(TraceBreakpointCommon breakpoint) {
        if (breakpoint instanceof TraceBreakpointLocation) {
            TraceBreakpointLocation loc = (TraceBreakpointLocation)breakpoint;
            return this.deleteBreakpointLocAsync(loc);
        }
        if (breakpoint instanceof TraceBreakpointSpec) {
            TraceBreakpointSpec spec = (TraceBreakpointSpec)breakpoint;
            return this.deleteBreakpointSpecAsync(spec);
        }
        Msg.error((Object)((Object)this), (Object)("Unrecognized TraceBreakpoint: " + String.valueOf(breakpoint)));
        return AsyncUtils.nil();
    }

    protected CompletableFuture<Void> toggleBreakpointSpecAsync(TraceBreakpointSpec spec, boolean enabled) {
        KeyPath path = spec.getObject().getCanonicalPath();
        MatchedMethod toggleBreak = this.matches.getBest(ToggleBreakMatcher.class, path, ActionName.TOGGLE, ToggleBreakMatcher.SPEC);
        if (toggleBreak == null) {
            return AsyncUtils.nil();
        }
        return toggleBreak.method.invokeAsync(Map.ofEntries(Map.entry(toggleBreak.params.get("specification").name(), spec.getObject()), Map.entry(toggleBreak.params.get("enabled").name(), enabled))).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> toggleBreakpointLocAsync(TraceBreakpointLocation loc, boolean enabled) {
        KeyPath path = loc.getObject().getCanonicalPath();
        MatchedMethod toggleBreak = this.matches.getBest(ToggleBreakMatcher.class, path, ActionName.TOGGLE, ToggleBreakMatcher.ALL);
        if (toggleBreak == null) {
            Msg.debug((Object)((Object)this), (Object)"Falling back to toggle spec");
            return this.toggleBreakpointSpecAsync(loc.getSpecification(), enabled);
        }
        RemoteParameter paramLocation = toggleBreak.params.get("location");
        if (paramLocation != null) {
            return toggleBreak.method.invokeAsync(Map.ofEntries(Map.entry(paramLocation.name(), loc.getObject()), Map.entry(toggleBreak.params.get("enabled").name(), enabled))).toCompletableFuture().thenApply(__ -> null);
        }
        return this.toggleBreakpointSpecAsync(loc.getSpecification(), enabled);
    }

    public CompletableFuture<Void> toggleBreakpointAsync(TraceBreakpointCommon breakpoint, boolean enabled) {
        if (breakpoint instanceof TraceBreakpointLocation) {
            TraceBreakpointLocation loc = (TraceBreakpointLocation)breakpoint;
            return this.toggleBreakpointLocAsync(loc, enabled);
        }
        if (breakpoint instanceof TraceBreakpointSpec) {
            TraceBreakpointSpec spec = (TraceBreakpointSpec)breakpoint;
            return this.toggleBreakpointSpecAsync(spec, enabled);
        }
        Msg.error((Object)((Object)this), (Object)("Unrecognized TraceBreakpoint: " + String.valueOf(breakpoint)));
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> forceTerminateAsync() {
        Map<String, Target.ActionEntry> kills = this.collectByName(ActionName.KILL, null, Target.ObjectArgumentPolicy.CURRENT_AND_RELATED);
        for (Target.ActionEntry kill : kills.values()) {
            if (kill.requiresPrompt()) continue;
            return kill.invokeAsync(false).handle((v, e) -> {
                this.connection.forceCloseTrace(this.trace);
                return null;
            });
        }
        Msg.warn((Object)((Object)this), (Object)"Cannot find way to gracefully kill. Forcing close regardless.");
        this.connection.forceCloseTrace(this.trace);
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> disconnectAsync() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
    }

    public boolean isBusy() {
        return this.connection.isBusy((Target)this);
    }

    public void forciblyCloseTransactions() {
        this.connection.forciblyCloseTransactions((Target)this);
    }

    protected class Matches {
        private final Map<MatchKey, MatchedMethod> map = new HashMap<MatchKey, MatchedMethod>();

        protected Matches() {
        }

        public MatchKey makeKey(Class<? extends MethodMatcher> cls, ActionName action, KeyPath path) {
            TraceObjectSchema rootSchema = TraceRmiTarget.this.trace.getObjectManager().getRootSchema();
            if (rootSchema == null) {
                return null;
            }
            return new MatchKey(cls, action, path == null ? null : rootSchema.getSuccessorSchema(path));
        }

        public <T extends MethodMatcher> MatchedMethod getBest(Class<T> cls, KeyPath path, ActionName action, Supplier<List<T>> preferredSupplier) {
            return this.getBest(cls, path, action, preferredSupplier.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MethodMatcher> MatchedMethod getBest(Class<T> cls, KeyPath path, ActionName action, List<T> preferred) {
            MatchKey key = this.makeKey(cls, action, path);
            Map<MatchKey, MatchedMethod> map = this.map;
            synchronized (map) {
                return this.map.computeIfAbsent(key, k -> this.chooseBest(action, path, preferred));
            }
        }

        private MatchedMethod chooseBest(ActionName name, KeyPath path, List<? extends MethodMatcher> preferred) {
            if (preferred.isEmpty()) {
                return null;
            }
            TraceObjectSchema rootSchema = TraceRmiTarget.this.trace.getObjectManager().getRootSchema();
            if (rootSchema == null) {
                return null;
            }
            MatchedMethod best = TraceRmiTarget.this.connection.getMethods().getByAction(name).stream().map(m -> MethodMatcher.matchPreferredForm(m, rootSchema, path, preferred)).filter(f -> f != null).max(MatchedMethod::compareTo).orElse(null);
            if (best == null) {
                Msg.debug((Object)this, (Object)("No suitable " + String.valueOf(name) + " method"));
            }
            return best;
        }
    }

    protected static class DorkedRequestCaches
    implements RequestCaches {
        protected DorkedRequestCaches() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void invalidateMemory() {
        }

        @Override
        public CompletableFuture<Void> readBlock(Address min, RemoteMethod method, Map<String, Object> args) {
            return method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
        }

        @Override
        public CompletableFuture<Void> readRegs(TraceObject obj, RemoteMethod method, Map<String, Object> args) {
            return method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
        }
    }

    static interface RequestCaches {
        public void invalidate();

        public void invalidateMemory();

        public CompletableFuture<Void> readBlock(Address var1, RemoteMethod var2, Map<String, Object> var3);

        public CompletableFuture<Void> readRegs(TraceObject var1, RemoteMethod var2, Map<String, Object> var3);
    }

    record ActivateMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static List<ActivateMatcher> makeAllFor(int addScore, ParamSpec focusSpec) {
            ActivateMatcher hasFocusTime = new ActivateMatcher(addScore + 3, List.of(focusSpec, new TypeParamSpec("time", String.class)));
            ActivateMatcher hasFocusSnap = new ActivateMatcher(addScore + 2, List.of(focusSpec, new TypeParamSpec("snap", Long.class)));
            ActivateMatcher hasFocus = new ActivateMatcher(addScore + 1, List.of(focusSpec));
            return TraceRmiTarget.matchers((MethodMatcher[])new ActivateMatcher[]{hasFocusTime, hasFocusSnap, hasFocus});
        }

        static List<ActivateMatcher> makeBySpecificity(TraceObjectSchema rootSchema, KeyPath path) {
            ArrayList<ActivateMatcher> result = new ArrayList<ActivateMatcher>();
            result.addAll(ActivateMatcher.makeAllFor((path.size() + 1) * 3, new TypeParamSpec("focus", TraceObject.class)));
            List schemas = rootSchema.getSuccessorSchemas(path);
            for (int i = path.size(); i > 0; --i) {
                result.addAll(ActivateMatcher.makeAllFor(i * 3, new SchemaParamSpec("focus", ((TraceObjectSchema)schemas.get(i)).getName())));
            }
            return TraceRmiTarget.matchers(result);
        }
    }

    record MatchedMethod(RemoteMethod method, Map<String, RemoteParameter> params, int score) implements Comparable<MatchedMethod>
    {
        @Override
        public int compareTo(MatchedMethod that) {
            return Integer.compare(this.score, that.score);
        }
    }

    public static enum Missing {
        MISSING;

    }

    record ParamAndObjectArg(RemoteParameter param, TraceObject obj) {
    }

    class TraceRmiActionEntry
    implements Target.ActionEntry {
        private final RemoteMethod method;
        private final Map<String, Object> args;
        private final boolean requiresPrompt;
        private final long specificity;
        private final ParamAndObjectArg first;

        public TraceRmiActionEntry(RemoteMethod method, Map<String, Object> args) {
            this.method = method;
            this.args = args;
            this.requiresPrompt = args.values().contains((Object)Missing.MISSING);
            this.specificity = TraceRmiTarget.computeSpecificity(method, args);
            this.first = TraceRmiTarget.this.getFirstObjectArgument(method, args);
        }

        public String display() {
            return this.method.display();
        }

        public ActionName name() {
            return this.method.action();
        }

        public Icon icon() {
            return this.method.icon();
        }

        public String details() {
            return this.method.description();
        }

        public boolean requiresPrompt() {
            return this.requiresPrompt;
        }

        public long specificity() {
            return this.specificity;
        }

        public CompletableFuture<?> invokeAsyncWithoutTimeout(boolean prompt) {
            return TraceRmiTarget.this.invokeMethod(prompt, this.method, this.args);
        }

        public boolean isEnabled() {
            if (this.first == null) {
                return true;
            }
            if (this.first.obj == null) {
                return false;
            }
            return this.name().enabler().isEnabled(this.first.obj, TraceRmiTarget.this.getSnap());
        }
    }

    static interface MethodMatcher {
        default public MatchedMethod match(RemoteMethod method, TraceObjectSchema rootSchema, KeyPath path) {
            List<ParamSpec> spec = this.spec();
            if (spec.size() != method.parameters().size()) {
                return null;
            }
            HashMap<String, RemoteParameter> found = new HashMap<String, RemoteParameter>();
            for (ParamSpec ps : spec) {
                RemoteParameter param = ps.find(method, rootSchema, path);
                if (param == null) {
                    return null;
                }
                found.put(ps.name(), param);
            }
            return new MatchedMethod(method, Map.copyOf(found), this.score());
        }

        public List<ParamSpec> spec();

        public int score();

        public static MatchedMethod matchPreferredForm(RemoteMethod method, TraceObjectSchema rootSchema, KeyPath path, List<? extends MethodMatcher> preferred) {
            return preferred.stream().map(m -> m.match(method, rootSchema, path)).filter(m -> m != null).findFirst().orElse(null);
        }
    }

    record ExecuteMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ExecuteMatcher HAS_CMD_TOSTRING = new ExecuteMatcher(2, List.of(new TypeParamSpec("command", String.class), new TypeParamSpec("toString", Boolean.class)));
        static final List<ExecuteMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ExecuteMatcher[]{HAS_CMD_TOSTRING});
    }

    record ReadMemMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ReadMemMatcher HAS_PROC_RANGE = new ReadMemMatcher(2, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("range", AddressRange.class)));
        static final ReadMemMatcher HAS_RANGE = new ReadMemMatcher(1, List.of(new TypeParamSpec("range", AddressRange.class)));
        static final List<ReadMemMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ReadMemMatcher[]{HAS_PROC_RANGE, HAS_RANGE});
    }

    record WriteMemMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final WriteMemMatcher HAS_PROC_START_DATA = new WriteMemMatcher(2, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("start", Address.class), new TypeParamSpec("data", byte[].class)));
        static final WriteMemMatcher HAS_START_DATA = new WriteMemMatcher(1, List.of(new TypeParamSpec("start", Address.class), new TypeParamSpec("data", byte[].class)));
        static final List<WriteMemMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new WriteMemMatcher[]{HAS_PROC_START_DATA, HAS_START_DATA});
    }

    record ReadRegsMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ReadRegsMatcher HAS_CONTAINER = new ReadRegsMatcher(3, List.of(new TypeParamSpec("container", TraceRegisterContainer.class)));
        static final ReadRegsMatcher HAS_REGISTER = new ReadRegsMatcher(1, List.of(new TypeParamSpec("register", TraceRegister.class)));
        static final List<ReadRegsMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ReadRegsMatcher[]{HAS_CONTAINER, HAS_REGISTER});
    }

    record FoundRegister(Register register, TraceObjectValue value) {
        String name() {
            return KeyPath.parseIfIndex((String)this.value.getEntryKey());
        }
    }

    record WriteRegMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final WriteRegMatcher HAS_FRAME_NAME_VALUE = new WriteRegMatcher(3, List.of(new TypeParamSpec("frame", TraceStackFrame.class), new TypeParamSpec("name", String.class), new TypeParamSpec("value", byte[].class)));
        static final WriteRegMatcher HAS_THREAD_NAME_VALUE = new WriteRegMatcher(2, List.of(new TypeParamSpec("thread", TraceThread.class), new TypeParamSpec("name", String.class), new TypeParamSpec("value", byte[].class)));
        static final WriteRegMatcher HAS_REG_VALUE = new WriteRegMatcher(1, List.of(new TypeParamSpec("register", TraceRegister.class), new TypeParamSpec("value", byte[].class)));
        static final List<WriteRegMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new WriteRegMatcher[]{HAS_FRAME_NAME_VALUE, HAS_REG_VALUE});
    }

    record BreakExecMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final BreakExecMatcher HAS_PROC_ADDR_COND_CMDS = new BreakExecMatcher(8, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR_COND = new BreakExecMatcher(7, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR_CMDS = new BreakExecMatcher(6, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR = new BreakExecMatcher(5, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("address", Address.class)));
        static final BreakExecMatcher HAS_ADDR_COND_CMDS = new BreakExecMatcher(4, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_ADDR_COND = new BreakExecMatcher(3, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class)));
        static final BreakExecMatcher HAS_ADDR_CMDS = new BreakExecMatcher(2, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_ADDR = new BreakExecMatcher(1, List.of(new TypeParamSpec("address", Address.class)));
        static final List<BreakExecMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new BreakExecMatcher[]{HAS_PROC_ADDR_COND_CMDS, HAS_PROC_ADDR_COND, HAS_PROC_ADDR_CMDS, HAS_PROC_ADDR, HAS_ADDR_COND_CMDS, HAS_ADDR_COND, HAS_ADDR_CMDS, HAS_ADDR});
    }

    record BreakAccMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final BreakAccMatcher HAS_PROC_RNG_COND_CMDS = new BreakAccMatcher(8, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG_COND = new BreakAccMatcher(7, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG_CMDS = new BreakAccMatcher(6, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG = new BreakAccMatcher(5, List.of(new TypeParamSpec("process", TraceProcess.class), new TypeParamSpec("range", AddressRange.class)));
        static final BreakAccMatcher HAS_RNG_COND_CMDS = new BreakAccMatcher(4, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_RNG_COND = new BreakAccMatcher(3, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class)));
        static final BreakAccMatcher HAS_RNG_CMDS = new BreakAccMatcher(2, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_RNG = new BreakAccMatcher(1, List.of(new TypeParamSpec("range", AddressRange.class)));
        static final List<BreakAccMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new BreakAccMatcher[]{HAS_PROC_RNG_COND_CMDS, HAS_PROC_RNG_COND, HAS_PROC_RNG_CMDS, HAS_PROC_RNG, HAS_RNG_COND_CMDS, HAS_RNG_COND, HAS_RNG_CMDS, HAS_RNG});
    }

    record DelBreakMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final DelBreakMatcher HAS_LOC = new DelBreakMatcher(2, List.of(new TypeParamSpec("location", TraceBreakpointLocation.class)));
        static final DelBreakMatcher HAS_SPEC = new DelBreakMatcher(1, List.of(new TypeParamSpec("specification", TraceBreakpointSpec.class)));
        static final List<DelBreakMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new DelBreakMatcher[]{HAS_LOC, HAS_SPEC});
        static final List<DelBreakMatcher> SPEC = TraceRmiTarget.matchers((MethodMatcher[])new DelBreakMatcher[]{HAS_SPEC});
    }

    record ToggleBreakMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ToggleBreakMatcher HAS_LOC = new ToggleBreakMatcher(2, List.of(new TypeParamSpec("location", TraceBreakpointLocation.class), new TypeParamSpec("enabled", Boolean.class)));
        static final ToggleBreakMatcher HAS_SPEC = new ToggleBreakMatcher(1, List.of(new TypeParamSpec("specification", TraceBreakpointSpec.class), new TypeParamSpec("enabled", Boolean.class)));
        static final List<ToggleBreakMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ToggleBreakMatcher[]{HAS_LOC, HAS_SPEC});
        static final List<ToggleBreakMatcher> SPEC = TraceRmiTarget.matchers((MethodMatcher[])new ToggleBreakMatcher[]{HAS_SPEC});
    }

    protected static class DefaultRequestCaches
    implements RequestCaches {
        final Map<TraceObject, CompletableFuture<Void>> readRegs = new HashMap<TraceObject, CompletableFuture<Void>>();
        final Map<Address, CompletableFuture<Void>> readBlock = new HashMap<Address, CompletableFuture<Void>>();

        protected DefaultRequestCaches() {
        }

        @Override
        public synchronized void invalidateMemory() {
            this.readBlock.clear();
        }

        @Override
        public synchronized void invalidate() {
            this.readRegs.clear();
            this.readBlock.clear();
        }

        @Override
        public synchronized CompletableFuture<Void> readRegs(TraceObject obj, RemoteMethod method, Map<String, Object> args) {
            return this.readRegs.computeIfAbsent(obj, o -> method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null));
        }

        @Override
        public synchronized CompletableFuture<Void> readBlock(Address min, RemoteMethod method, Map<String, Object> args) {
            return this.readBlock.computeIfAbsent(min, m -> method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null));
        }
    }

    record MatchKey(Class<? extends MethodMatcher> cls, ActionName action, TraceObjectSchema sch) {
    }

    record NameParamSpec(String name, Class<?> type) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, TraceObjectSchema rootSchema, KeyPath path) {
            RemoteParameter param = (RemoteParameter)method.parameters().get(this.name);
            if (param != null && TraceRmiTarget.typeMatches(method, param, rootSchema, path, this.type)) {
                return param;
            }
            return null;
        }
    }

    record TypeParamSpec(String name, Class<?> type) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, TraceObjectSchema rootSchema, KeyPath path) {
            List<RemoteParameter> withType = method.parameters().values().stream().filter(p -> TraceRmiTarget.typeMatches(method, p, rootSchema, path, this.type)).toList();
            if (withType.size() != 1) {
                return null;
            }
            return withType.get(0);
        }
    }

    record SchemaParamSpec(String name, TraceObjectSchema.SchemaName schema) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, TraceObjectSchema rootSchema, KeyPath path) {
            List<RemoteParameter> withType = method.parameters().values().stream().filter(p -> this.schema.equals((Object)p.type())).toList();
            if (withType.size() != 1) {
                return null;
            }
            return withType.get(0);
        }
    }

    static interface ParamSpec {
        public String name();

        public RemoteParameter find(RemoteMethod var1, TraceObjectSchema var2, KeyPath var3);
    }
}

