/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.util.Msg;
import java.io.IOException;

public class SquashMetablock {
    private final short header;

    public SquashMetablock(BinaryReader reader) throws IOException {
        this.header = reader.readNextShort();
    }

    public boolean isCompressed() {
        return (this.header & 0x8000) == 0;
    }

    public short getBlockSize() {
        short blockSize = (short)(this.header & 0xFFFF7FFF);
        if (blockSize > 8192) {
            Msg.warn((Object)this, (Object)"Unit block size is too large!");
        }
        return blockSize;
    }
}

