/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.StructConverter;
import ghidra.util.NumericUtilities;

public abstract class BootImageHeader
implements StructConverter {
    public abstract String getMagic();

    public abstract int getPageSize();

    public long pageAlign(long value) {
        return NumericUtilities.getUnsignedAlignedValue((long)value, (long)this.getPageSize());
    }

    public abstract int getKernelSize();

    public abstract int getKernelPageCount();

    public abstract long getKernelOffset();

    public abstract int getRamdiskSize();

    public abstract int getRamdiskPageCount();

    public abstract int getRamdiskOffset();

    public abstract int getSecondSize();

    public abstract int getSecondPageCount();

    public abstract long getSecondOffset();

    public abstract String getCommandLine();
}

