/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.map.MapView;

public class MapViewScrollPane
extends JScrollPane
implements IFreeplanePropertyListener {
    private static final Dimension INVISIBLE = new Dimension(0, 0);
    public static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    private static final long serialVersionUID = 1L;
    private final Border defaultBorder;

    public MapViewScrollPane() {
        super(22, 32);
        this.setViewport(new MapViewPort());
        this.defaultBorder = this.getBorder();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && MapViewScrollPane.this.isShowing() && !MapViewScrollPane.this.isValid()) {
                    MapViewScrollPane.this.revalidate();
                    MapViewScrollPane.this.repaint();
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setScrollbarsVisiblilty();
        UITools.setScrollbarIncrement(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ResourceController.getResourceController().removePropertyChangeListener(this);
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        SwingUtilities.replaceUIInputMap(this, 1, null);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if ("fullscreen_enabled".equals(propertyName) || propertyName.startsWith("scrollbarsVisible")) {
            this.setScrollbarsVisiblilty();
        } else if (propertyName.equals("scrollbar_increment")) {
            int scrollbarIncrement = Integer.valueOf(newValue);
            this.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
            this.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
        }
    }

    private void setScrollbarsVisiblilty() {
        ViewController viewController = Controller.getCurrentController().getViewController();
        boolean areScrollbarsVisible = viewController.areScrollbarsVisible();
        if (areScrollbarsVisible) {
            this.getVerticalScrollBar().setPreferredSize(null);
            this.getHorizontalScrollBar().setPreferredSize(null);
        } else {
            this.getVerticalScrollBar().setPreferredSize(INVISIBLE);
            this.getHorizontalScrollBar().setPreferredSize(INVISIBLE);
        }
        boolean isFullScreenEnabled = viewController.isFullScreenEnabled();
        this.setBorder(isFullScreenEnabled && !areScrollbarsVisible ? BorderFactory.createEmptyBorder() : this.defaultBorder);
        this.revalidate();
        this.repaint();
    }

    public void addViewportReservedAreaSupplier(ViewportReservedAreaSupplier supplier) {
        ((MapViewPort)this.getViewport()).addReservedAreaSupplier(supplier);
    }

    public void removeReservedAreaSupplier(ViewportReservedAreaSupplier supplier) {
        ((MapViewPort)this.getViewport()).removeReservedAreaSupplier(supplier);
    }

    @Override
    public void doLayout() {
        Component view;
        if (this.viewport != null && (view = this.viewport.getView()) != null) {
            view.invalidate();
        }
        super.doLayout();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        ActionAcceleratorManager acceleratorManager;
        if (this.viewport != null && (acceleratorManager = ResourceController.getResourceController().getAcceleratorManager()).canProcessKeyEvent(e)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    static class MapViewPort
    extends JViewport {
        private List<ViewportReservedAreaSupplier> reservedAreaSuppliers = new ArrayList<ViewportReservedAreaSupplier>();
        private boolean layoutInProgress = false;
        private Timer timer;
        private ScalableComponent backgroundComponent;
        private boolean scrollsRectangleToVisible;
        private Point targetViewPosition;
        private int scrollingDelay = 0;

        MapViewPort() {
        }

        void addReservedAreaSupplier(ViewportReservedAreaSupplier supplier) {
            this.removeReservedAreaSupplier(supplier);
            this.reservedAreaSuppliers.add(supplier);
        }

        void removeReservedAreaSupplier(ViewportReservedAreaSupplier supplier) {
            this.reservedAreaSuppliers.remove(supplier);
        }

        @Override
        public void doLayout() {
            this.layoutInProgress = true;
            super.doLayout();
            this.layoutInProgress = false;
        }

        @Override
        protected void validateTree() {
            super.validateTree();
            Component view = this.getView();
            if (view != null) {
                ((MapView)view).scrollViewAfterLayout();
                if (!this.isValid()) {
                    super.validateTree();
                }
            }
        }

        public void setBackgroundComponent(ScalableComponent backgroundComponent) {
            this.backgroundComponent = backgroundComponent;
        }

        @Override
        public void scrollRectToVisible(Rectangle contentRectangle) {
            int targetDY;
            int targetDX;
            boolean isTooHigh;
            int width = this.getWidth();
            int height = this.getHeight();
            boolean isTooWide = contentRectangle.width >= width;
            boolean bl = isTooHigh = contentRectangle.height >= height;
            if (this.targetViewPosition != null) {
                Component view = this.getView();
                targetDX = -this.targetViewPosition.x - view.getX();
                targetDY = -this.targetViewPosition.y - view.getY();
                contentRectangle.x += targetDX;
                contentRectangle.y += targetDY;
            } else {
                targetDY = 0;
                targetDX = 0;
            }
            if (isTooWide && isTooHigh) {
                this.scrollRectToVisibleWithoutAdjustment(contentRectangle);
            } else {
                boolean adjustBottom;
                boolean adjustRight;
                Rectangle candidateRect = new Rectangle(contentRectangle);
                int dx = this.positionAdjustment(this.getWidth(), contentRectangle.width, contentRectangle.x);
                int dy = this.positionAdjustment(this.getHeight(), contentRectangle.height, contentRectangle.y);
                int leftInset = 0;
                int rightInset = 0;
                int topInset = 0;
                int bottomInset = 0;
                for (ViewportReservedAreaSupplier supplier : this.reservedAreaSuppliers) {
                    boolean overlapsOnYAxis;
                    boolean isAtTheBottom;
                    Rectangle reservedArea = supplier.getReservedArea();
                    if (reservedArea.width == 0 || reservedArea.height == 0) continue;
                    Rectangle r = new Rectangle(reservedArea);
                    r.x -= this.getX();
                    if (r.x < 0) {
                        r.width += r.x;
                        r.x = 0;
                    }
                    r.y -= this.getY();
                    if (r.y < 0) {
                        r.height += r.y;
                        r.y = 0;
                    }
                    if (r.x + r.width > width) {
                        r.width = width - r.x;
                    }
                    if (r.y + r.height > height) {
                        r.height = height - r.y;
                    }
                    boolean isOnTheLeft = r.x == 0;
                    boolean isOnTheRight = r.x + r.width == width;
                    boolean isAtTheTop = r.y == 0;
                    boolean bl2 = isAtTheBottom = r.y + r.height == height;
                    if (!isOnTheLeft && !isOnTheRight && !isAtTheTop && !isAtTheBottom) continue;
                    boolean overlapsOnXAxis = contentRectangle.x + dx < r.x + r.width && contentRectangle.x + dx + contentRectangle.width > r.x;
                    boolean bl3 = overlapsOnYAxis = contentRectangle.y + dy < r.y + r.height && contentRectangle.y + dy + contentRectangle.height > r.y;
                    if (!overlapsOnXAxis || !overlapsOnYAxis) continue;
                    if (isOnTheLeft && !isOnTheRight && !isTooWide && (isAtTheTop == isAtTheBottom || r.width < r.height || isTooHigh)) {
                        leftInset = Math.max(leftInset, r.width);
                        continue;
                    }
                    if (isOnTheRight && !isOnTheLeft && !isTooWide && (isAtTheTop == isAtTheBottom || r.width < r.height || isTooHigh)) {
                        rightInset = Math.max(rightInset, r.width);
                        continue;
                    }
                    if (isAtTheTop && !isAtTheBottom && !isTooHigh && (isOnTheRight == isOnTheLeft || r.height <= r.width || isTooWide)) {
                        topInset = Math.max(topInset, r.height);
                        continue;
                    }
                    if (!isAtTheBottom || isAtTheTop || isTooHigh || isOnTheRight != isOnTheLeft && r.height > r.width && !isTooWide) continue;
                    bottomInset = Math.max(bottomInset, r.height);
                }
                boolean adjustLeft = leftInset > 0 && contentRectangle.x < leftInset;
                boolean bl4 = adjustRight = rightInset > 0 && contentRectangle.x + contentRectangle.width > width - rightInset;
                if (adjustLeft && !adjustRight && leftInset >= rightInset) {
                    candidateRect.x = contentRectangle.x - leftInset;
                    candidateRect.width = contentRectangle.width + leftInset;
                } else if (adjustRight && !adjustLeft && rightInset >= leftInset) {
                    candidateRect.width = contentRectangle.width + rightInset;
                } else if (adjustLeft && adjustRight) {
                    candidateRect.x = contentRectangle.x - leftInset;
                    candidateRect.width = contentRectangle.width + leftInset + rightInset;
                }
                boolean adjustTop = topInset > 0 && contentRectangle.y < topInset;
                boolean bl5 = adjustBottom = bottomInset > 0 && contentRectangle.y + contentRectangle.height > height - bottomInset;
                if (adjustTop && !adjustBottom && topInset >= bottomInset) {
                    candidateRect.y = contentRectangle.y - topInset;
                    candidateRect.height = contentRectangle.height + topInset;
                } else if (adjustBottom && !adjustTop && bottomInset >= topInset) {
                    candidateRect.height = contentRectangle.height + bottomInset;
                } else if (adjustTop && adjustBottom) {
                    candidateRect.y = contentRectangle.y - topInset;
                    candidateRect.height = contentRectangle.height + topInset + bottomInset;
                }
                this.scrollRectToVisibleWithoutAdjustment(candidateRect);
            }
            contentRectangle.x -= targetDX;
            contentRectangle.y -= targetDY;
        }

        private void scrollRectToVisibleWithoutAdjustment(Rectangle contentRectangle) {
            boolean scrollsRectangleToVisible = this.scrollsRectangleToVisible;
            this.scrollsRectangleToVisible = true;
            try {
                super.scrollRectToVisible(contentRectangle);
                if (this.targetViewPosition == null) {
                    this.scrollingDelay = 0;
                }
            }
            finally {
                this.scrollsRectangleToVisible = scrollsRectangleToVisible;
            }
        }

        @Override
        public Point getViewPosition() {
            if (this.targetViewPosition != null && this.scrollsRectangleToVisible) {
                return this.targetViewPosition;
            }
            return super.getViewPosition();
        }

        private int positionAdjustment(int parentWidth, int childWidth, int childAt) {
            if (childAt >= 0 && childWidth + childAt <= parentWidth) {
                return 0;
            }
            if (childAt > 0 && childWidth <= parentWidth) {
                return -childAt + parentWidth - childWidth;
            }
            if (childAt <= 0 && childWidth <= parentWidth) {
                return -childAt;
            }
            return 0;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.backgroundComponent != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.backgroundComponent.paintComponent(g);
            }
        }

        @Override
        public boolean isOpaque() {
            return this.backgroundComponent != null && this.getBackground().getAlpha() == 255;
        }

        @Override
        public void setViewPosition(Point p) {
            if (!this.layoutInProgress) {
                if (this.scrollingDelay != 0) {
                    if (this.targetViewPosition == null) {
                        SwingUtilities.invokeLater(this::slowSetViewPosition);
                    }
                    this.targetViewPosition = p;
                } else {
                    this.stopTimer();
                    this.layoutInProgress = true;
                    super.setViewPosition(p);
                    this.layoutInProgress = false;
                    MapView view = (MapView)this.getView();
                    if (view != null) {
                        view.setAnchorContentLocation();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBounds(int x, int y, int width, int height) {
            boolean layoutWasInProgress = this.layoutInProgress;
            this.layoutInProgress = true;
            try {
                int dX = (width - this.getWidth()) / 2;
                int dY = (height - this.getHeight()) / 2;
                if (dX != 0 || dY != 0) {
                    Point viewPosition = this.getViewPosition();
                    viewPosition.x += dX;
                    viewPosition.y += dY;
                    super.setViewPosition(viewPosition);
                }
                super.setBounds(x, y, width, height);
            }
            finally {
                this.layoutInProgress = layoutWasInProgress;
            }
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Component view = this.getView();
            if (view != null) {
                Dimension oldSize = view.getSize();
                if (newSize.equals(oldSize)) {
                    view.setSize(newSize);
                } else {
                    super.setViewSize(newSize);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void slowSetViewPosition() {
            this.stopTimer();
            Point currentViewPosition = super.getViewPosition();
            if (this.targetViewPosition == null) {
                return;
            }
            if (this.isValid()) {
                int dx = this.targetViewPosition.x - currentViewPosition.x;
                int dy = this.targetViewPosition.y - currentViewPosition.y;
                int slowDx = this.calcScrollIncrement(dx);
                int slowDy = this.calcScrollIncrement(dy);
                currentViewPosition.translate(slowDx, slowDy);
                boolean layoutWasInProgress = this.layoutInProgress;
                this.layoutInProgress = true;
                try {
                    super.setViewPosition(currentViewPosition);
                }
                finally {
                    this.layoutInProgress = layoutWasInProgress;
                }
                if (slowDx == dx && slowDy == dy) {
                    this.targetViewPosition = null;
                    this.scrollingDelay = 0;
                    MapView view = (MapView)this.getView();
                    if (view != null) {
                        view.setAnchorContentLocation();
                    }
                    return;
                }
            }
            this.timer = new Timer(this.scrollingDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    timer = null;
                    this.slowSetViewPosition();
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        private int calcScrollIncrement(int dx) {
            if (this.scrollingDelay == 0) {
                return dx;
            }
            int v = ResourceController.getResourceController().getIntProperty("scrolling_speed");
            int absDx = Math.abs(dx);
            double sqrtDx = Math.sqrt(absDx);
            int slowDX = (int)Math.max((double)absDx * sqrtDx / (double)this.scrollingDelay, (double)this.scrollingDelay * sqrtDx) * v / 100;
            if (Math.abs(dx) > 2 && slowDX < Math.abs(dx)) {
                dx = slowDX * Integer.signum(dx);
            }
            return dx;
        }

        void startSlowScrolling(int scrollingDelay) {
            this.scrollingDelay = scrollingDelay;
        }
    }

    @FunctionalInterface
    public static interface ViewportReservedAreaSupplier {
        public Rectangle getReservedArea();
    }
}

