/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;

public class ModelSelectorField {
    private static final Log log = Log.getLog(ModelSelectorField.class);
    @NotNull
    private final Combo combo;
    @NotNull
    private final ModelListProvider modelListProvider;
    private volatile String selectedModel;
    private boolean disableModifyListener = false;

    private ModelSelectorField(@NotNull Combo combo, @NotNull ModelListProvider modelListProvider, @Nullable Runnable onModelModify) {
        this.combo = combo;
        if (onModelModify != null) {
            this.combo.addModifyListener(e -> {
                String newText = combo.getText();
                if (!newText.equals(this.selectedModel) && !this.disableModifyListener) {
                    this.selectedModel = newText;
                    onModelModify.run();
                }
            });
        } else {
            this.combo.addModifyListener(e -> {
                this.selectedModel = combo.getText();
            });
        }
        this.modelListProvider = modelListProvider;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(@Nullable String model) {
        if (model == null || model.isBlank()) {
            return;
        }
        this.combo.setText(model);
    }

    public void refreshModelListSilently(final boolean refresh) {
        new AbstractJob(this, "Refreshing model list silently"){
            final /* synthetic */ ModelSelectorField this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    this.this$0.refreshModelList(monitor, refresh);
                    return Status.OK_STATUS;
                }
                catch (DBException e) {
                    log.debug((Object)"Error reading model list", (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
    }

    public void refreshModelList(DBRProgressMonitor monitor, boolean refresh) throws DBException {
        HashSet<String> models = new HashSet<String>(this.modelListProvider.getModels(monitor, refresh));
        if (models.isEmpty()) {
            return;
        }
        UIUtils.syncExec(() -> {
            if (this.combo.isDisposed()) {
                return;
            }
            String selectedItem = this.combo.getText();
            models.add(selectedItem);
            List sortedModels = new ArrayList(models).stream().sorted(String::compareToIgnoreCase).toList();
            this.disableModifyListener = true;
            this.combo.setItems(sortedModels.toArray(new String[0]));
            this.disableModifyListener = false;
            this.combo.select(sortedModels.indexOf(selectedItem));
        });
    }

    public static interface ModelListProvider {
        @NotNull
        public List<String> getModels(@NotNull DBRProgressMonitor var1, boolean var2) throws DBException;
    }

    public static class Builder {
        @NotNull
        private Composite parent;
        @NotNull
        private GridData gridData;
        @Nullable
        private Runnable onModify;
        @NotNull
        private ModelListProvider modelListSupplier;
        private String modelLabel = AIUIMessages.gpt_preference_page_combo_engine;

        public Builder withParent(@NotNull Composite parent) {
            this.parent = parent;
            return this;
        }

        public Builder withGridData(@NotNull GridData gridData) {
            this.gridData = gridData;
            return this;
        }

        public Builder withModifyListener(@NotNull Runnable onModify) {
            this.onModify = onModify;
            return this;
        }

        public Builder withModelListSupplier(@NotNull ModelListProvider modelListProvider) {
            this.modelListSupplier = modelListProvider;
            return this;
        }

        public Builder withModelLabel(@NotNull String modelLabel) {
            this.modelLabel = modelLabel;
            return this;
        }

        @NotNull
        public ModelSelectorField build() {
            Combo combo = UIUtils.createLabelCombo((Composite)this.parent, (String)this.modelLabel, (int)4);
            combo.setLayoutData((Object)this.gridData);
            final ModelSelectorField modelSelectorField = new ModelSelectorField(combo, this.modelListSupplier, this.onModify);
            UIUtils.createPushButton((Composite)this.parent, null, (String)AIUIMessages.gpt_preference_page_refresh_models, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new AbstractJob(this, "Refreshing model list"){

                @NotNull
                protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                    try {
                        modelSelectorField.refreshModelList(monitor, true);
                        return Status.OK_STATUS;
                    }
                    catch (DBException exception) {
                        DBWorkbench.getPlatformUI().showError("Error reading model list", null, (Throwable)exception);
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule()));
            return modelSelectorField;
        }
    }
}

