/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;
import org.jkiss.utils.CommonUtils;

public enum QMObjectType {
    session("Session", List.of(QMMetaObjectType.CONNECTION_INFO)),
    txn("Transactions", List.of(QMMetaObjectType.TRANSACTION_INFO, QMMetaObjectType.TRANSACTION_SAVEPOINT_INFO)),
    query("Queries", List.of());

    private final String title;
    private final List<QMMetaObjectType> types;

    private QMObjectType(String title, List<QMMetaObjectType> types) {
        this.title = title;
        this.types = types;
    }

    public List<QMMetaObjectType> getTypes() {
        return this.types;
    }

    public String getTitle() {
        return this.title;
    }

    public static String toString(Collection<QMObjectType> objectTypes) {
        ArrayList<String> names = new ArrayList<String>(objectTypes.size());
        for (QMObjectType type : objectTypes) {
            names.add(type.name());
        }
        return CommonUtils.makeString(names, (char)',');
    }

    public static Collection<QMObjectType> fromString(String str) {
        ArrayList<QMObjectType> objectTypes = new ArrayList<QMObjectType>();
        for (String otName : CommonUtils.splitString((String)str, (char)',')) {
            try {
                objectTypes.add(QMObjectType.valueOf(otName));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return objectTypes;
    }
}

