/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLSetDelimiterToken;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPEvalScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class SQLDelimiterSetRule
implements TPRule {
    private final String setDelimiterWord;
    private final SQLSetDelimiterToken setDelimiterToken;
    private final SQLDelimiterRule delimiterRule;

    public SQLDelimiterSetRule(String setDelimiterWord, SQLSetDelimiterToken setDelimiterToken, SQLDelimiterRule delimiterRule) {
        this.setDelimiterWord = setDelimiterWord;
        this.setDelimiterToken = setDelimiterToken;
        this.delimiterRule = delimiterRule;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        if (scanner.getOffset() > 0) {
            scanner.unread();
            int prevChar = scanner.read();
            if (prevChar != -1 && prevChar != 13 && prevChar != 10) {
                return TPTokenAbstract.UNDEFINED;
            }
        }
        int i = 0;
        while (i < this.setDelimiterWord.length()) {
            char c = this.setDelimiterWord.charAt(i);
            int nextChar = scanner.read();
            if (Character.toUpperCase(nextChar) != c) {
                int k = 0;
                while (k <= i) {
                    scanner.unread();
                    ++k;
                }
                return TPTokenAbstract.UNDEFINED;
            }
            ++i;
        }
        StringBuilder delimBuffer = new StringBuilder();
        int delimLength = 0;
        int next = scanner.read();
        if (next == -1 || next == 10 || next == 13) {
            scanner.unread();
        } else {
            if (!Character.isWhitespace(next)) {
                int k = 0;
                while (k < this.setDelimiterWord.length() + 1) {
                    scanner.unread();
                    ++k;
                }
                return TPTokenAbstract.UNDEFINED;
            }
            while ((next = scanner.read()) != -1 && next != 10 && next != 13) {
                if (delimLength == 0 && delimBuffer.length() > 0 && Character.isWhitespace(next)) {
                    delimLength = delimBuffer.length();
                }
                delimBuffer.append((char)next);
            }
            scanner.unread();
        }
        if (scanner instanceof TPEvalScanner && ((TPEvalScanner)scanner).isEvalMode()) {
            String newDelimiter = delimLength <= 0 ? delimBuffer.toString().trim() : delimBuffer.substring(0, delimLength).trim();
            this.delimiterRule.changeDelimiter(newDelimiter);
        }
        return this.setDelimiterToken;
    }
}

