/**
 * Simple debug logging for standalone sandbox
 */
export function logForDebugging(message, options) {
    // Only log if SRT_DEBUG environment variable is set
    // Using SRT_DEBUG instead of DEBUG to avoid conflicts with other tools
    // (DEBUG is commonly used by Node.js debug libraries and VS Code)
    if (!process.env.SRT_DEBUG) {
        return;
    }
    const level = options?.level || 'info';
    const prefix = '[SandboxDebug]';
    // Always use stderr to avoid corrupting stdout JSON streams
    switch (level) {
        case 'error':
            console.error(`${prefix} ${message}`);
            break;
        case 'warn':
            console.warn(`${prefix} ${message}`);
            break;
        default:
            console.error(`${prefix} ${message}`);
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/@anthropic-ai/sandbox-runtime/dist/utils/debug.js.map