/**
 * Sequence - Simple Refactoring
 * ./src/krill/sequence.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import CliAutologin from '../../classes/cli-autologin.js';
import Settings from '../../classes/settings.js';
import { IDevices, IDistro, IInstaller, INet, IRemix } from '../../interfaces/index.js';
import { IKeyboard, ILocation, IPartitions, IUsers } from '../interfaces/i_krill.js';
import addUser from './sequence.d/add_user.js';
import bootloader from './sequence.d/bootloader.js';
import bootloaderConfig from './sequence.d/bootloader_config.js';
import changePassword from './sequence.d/change_password.js';
import delLiveUser from './sequence.d/del_live_user.js';
import fstab from './sequence.d/fstab.js';
import grubcfg from './sequence.d/grubcfg.js';
import hostname from './sequence.d/hostname.js';
import initramfs from './sequence.d/initramfs.js';
import initramfsCfg from './sequence.d/initramfs_cfg.js';
import locale from './sequence.d/locale.js';
import localeCfg from './sequence.d/locale_cfg.js';
import mKeyboard from './sequence.d/m_keyboard.js';
import machineId from './sequence.d/machine_id.js';
import mkfs from './sequence.d/mkfs.js';
import { mountFs, umountFs } from './sequence.d/mount_fs.js';
import { mountVfs, umountVfs } from './sequence.d/mount_vfs.js';
import networkCfg from './sequence.d/network_cfg.js';
import packages from './sequence.d/packages.js';
import biosLuks from './sequence.d/partition.d/bios_luks.js';
import biosStandard from './sequence.d/partition.d/bios_standard.js';
import uefiLuks from './sequence.d/partition.d/uefi_luks.js';
import uefiStandard from './sequence.d/partition.d/uefi_standard.js';
import partition from './sequence.d/partition.js';
import removeHomecryptHack from './sequence.d/remove-homecrypt-hack.js';
import removeInstallerLink from './sequence.d/remove_installer_link.js';
import umount from './sequence.d/umount.js';
import unpackfs from './sequence.d/unpackfs.js';
/**
 * Main Sequence class - Simple Refactoring
 */
export default class Sequence {
    addUser: typeof addUser;
    bootloader: typeof bootloader;
    bootloaderConfig: typeof bootloaderConfig;
    changePassword: typeof changePassword;
    chroot: boolean;
    cliAutologin: CliAutologin;
    cryptedHomeDevice: string;
    delLiveUser: typeof delLiveUser;
    devices: IDevices;
    distro: IDistro;
    echo: {};
    efi: boolean;
    fstab: typeof fstab;
    grubcfg: typeof grubcfg;
    halt: boolean;
    hostname: typeof hostname;
    initramfs: typeof initramfs;
    initramfsCfg: typeof initramfsCfg;
    installer: IInstaller;
    installTarget: string;
    is_clone: boolean;
    keyboard: typeof mKeyboard;
    keyboardLayout: string;
    keyboardModel: string;
    keyboardVariant: string;
    language: string;
    locale: typeof locale;
    localeCfg: typeof localeCfg;
    luksRootName: string;
    machineId: typeof machineId;
    mkfs: typeof mkfs;
    mountFs: typeof mountFs;
    mountVfs: typeof mountVfs;
    network: INet;
    networkCfg: typeof networkCfg;
    nointeractive: boolean;
    packages: typeof packages;
    partition: typeof partition;
    partitionBiosLuks: typeof biosLuks;
    partitionBiosStandard: typeof biosStandard;
    partitions: IPartitions;
    partitionUefiLuks: typeof uefiLuks;
    partitionUefiStandard: typeof uefiStandard;
    region: string;
    remix: IRemix;
    removeHomecryptHack: typeof removeHomecryptHack;
    removeInstallerLink: typeof removeInstallerLink;
    settings: Settings;
    spinner: boolean;
    swapSize: number;
    toNull: string;
    umount: typeof umount;
    umountFs: typeof umountFs;
    umountVfs: typeof umountVfs;
    unattended: boolean;
    unpackfs: typeof unpackfs;
    users: IUsers;
    verbose: boolean;
    zone: string;
    /**
     * Constructor (unchanged)
     */
    constructor(location: ILocation, keyboard: IKeyboard, partitions: IPartitions, users: IUsers, network: INet);
    emergencyShell(message: string): Promise<void>;
    execCalamaresModule(name: string): Promise<void>;
    showProblem(message: string, currErr: any): Promise<void>;
    /**
     * Main start method - Much cleaner sequence
     */
    start(domain?: string, unattended?: boolean, nointeractive?: boolean, chroot?: boolean, halt?: boolean, verbose?: boolean): Promise<void>;
    /**
     * Complete installation with reboot/halt
     */
    private completeInstallation;
    /**
     * Helper method to execute a step with standard error handling
     */
    private executeStep;
    /**
     * Main installation sequence - Linear and clear
     */
    private runInstallationSequence;
    /**
     * Setup installation parameters and environment
     */
    private setupInstallation;
}
