/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef _MISCMANAGER_H
#define _MISCMANAGER_H

#include <qobject.h>
#include <qptrlist.h>

class KdetvMiscPlugin;
class PluginFactory;
class QWidget;

class MiscManager : public QObject
{
    Q_OBJECT

public:
    bool filterNumberKey(int key);

public slots:
    void scanPlugins();

protected:
    friend class Kdetv;
    MiscManager(PluginFactory*, QWidget*);
    ~MiscManager();

    void setScreen(QWidget* screen);

private:
    QPtrList<KdetvMiscPlugin> _plugs;
    QWidget* _view;
    PluginFactory* _pf;
};

#endif
