// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __CHANNELSTOREIFACE_H
#define __CHANNELSTOREIFACE_H

#include <dcopobject.h>
#include <dcopref.h>

/**
 * A DCOP interface for kdetv.
 *
 * @author Richard Moore, rich@kde.org
 */
class ChannelStoreIface : virtual public DCOPObject
{
    K_DCOP
k_dcop:
    virtual uint count() const=0;
    virtual bool isEmpty() const=0;

    /**
     * Returns a DCOP reference to the Channel at the specified index.
     */
    virtual DCOPRef channelIfaceAt( int idx )=0;

    virtual int removeChannel( int idx )=0;
    virtual int removeChannelNumber( int n )=0;
    virtual void renumber(int start)=0;
    virtual void renumber()=0;
    virtual void clear()=0;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:

