// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef KDETVPART_H
#define KDETVPART_H

#include <kparts/part.h>

class KPopupMenu;

class KdetvWidget;
class LibKdetvActions;

/**
 * KParts wrapper for a Kdetv widget.
 *
 * @author Richard Moore, <rich@kde.org>
 */
class KdetvPart : public KParts::ReadOnlyPart
{
    Q_OBJECT

public:
    KdetvPart( QWidget *wparent, const char *wname,
               QObject *parent, const char *name,
               const QStringList &args );
    virtual ~KdetvPart();

    /**
     * Returns the name of the file shown in the part.
     */
    QString filename() const { return m_file; }

    /**
     * Returns the KdetvWidget of this part.
     */
    virtual KdetvWidget *widget() const { return tv; }

    /**
     * Adds the standard context menu.
     */
    void addContextMenu( bool xmlgui = true );

    /**
     * Creates the standard screen context menu. If the  menu cannot be
     * loaded (or xmlgui is false) the default menu is created.
     */
    KPopupMenu *createContextMenu( bool xmlgui = true );

    /**
     * Creates the named context menu using XMLGUI.
     */
    KPopupMenu *createContextMenu( const QString &name );

    static KAboutData *createAboutData();

public slots:
    virtual void about();
    virtual void help();
    virtual void preferences();
    virtual void reportBug();

    void setAutoStart( bool enable ) { autoStart = enable; }
    void start();

protected:
    virtual bool openFile();

protected slots:
    void maybeStart();

private:
    KdetvWidget *tv;
    LibKdetvActions *actions;
    bool autoStart;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
