//***************************************************************************
//                          kbearfileiconview.cpp  -  description
//                             -------------------
//    begin                : Thu Jul 6 2000
//    copyright            : (C) 2000 by Bjrn Sahlstrm
//    email                : bjorn.sahlstrom@mail.bip.net
//***************************************************************************/

//***************************************************************************
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//***************************************************************************/

#include "kbearfileiconview.h"

//-----------------------------------------------
KBearFileIconView::KBearFileIconView( QWidget* p, const char *n )
 : KFileDnDIconView(p,n)
{
	setAutoUpdate( true );
	setIconSize( KIcon::SizeMedium );
	arrangeItemsInGrid ( true );
	setItemTextPos( QIconView::Bottom );
	setArrangement( QIconView::LeftToRight );
	setResizeMode( QIconView::Adjust );
	setGridX( 75 );
	connect( this, SIGNAL( openFolder( const QString ) ), SLOT( slotOpenFolder( const QString ) ) );
}
//-----------------------------------------------
KBearFileIconView::~KBearFileIconView(){
}
//-----------------------------------------------
void KBearFileIconView::slotOpenFolder( QString folderName ){
	KURL url = myOp->url();
	url.cd( folderName );
	myOp->setURL( url.path( 1 ), true );
}
//-----------------------------------------------
void KBearFileIconView::setOperator(QObject *ops) {
	KFileView::setOperator( ops );
	myOp = (KBearDirOperator*)ops;
}
//-----------------------------------------------
