/* rygel-media-object.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaObjectPrivate {
	RygelMediaContainer* _parent_ref;
	char* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeIterator* _uri_it;
	char* uri;
	GFile* file;
	GFileInfo* info;
	GError * _inner_error_;
};


static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;
static gpointer rygel_media_object_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE
};
static void rygel_media_object_get_writable_data_free (gpointer _data);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* data);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const char* prop1, const char* prop2);
const char* rygel_media_object_get_title (RygelMediaObject* self);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
void rygel_media_object_set_title (RygelMediaObject* self, const char* value);
static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void rygel_media_object_finalize (GObject* obj);
static void rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaObjectGetWritableData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_data_->self = g_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_object_get_writable_co (_data_);
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_object_get_writable_co (data);
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 22:
		goto _state_22;
	}
	_state_0:
	{
		data->_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->self->uris);
#line 109 "rygel-media-object.vala"
		while (TRUE) {
#line 109 "rygel-media-object.vala"
			if (!gee_iterator_next (data->_uri_it)) {
#line 109 "rygel-media-object.vala"
				break;
#line 228 "rygel-media-object.c"
			}
			data->uri = (char*) gee_iterator_get (data->_uri_it);
			data->file = g_file_new_for_uri (data->uri);
			data->_state_ = 22;
			g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->cancellable, rygel_media_object_get_writable_ready, data);
			return FALSE;
			_state_22:
			data->info = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_it);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 117 "rygel-media-object.vala"
			if (g_file_info_get_attribute_boolean (data->info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE)) {
#line 255 "rygel-media-object.c"
				data->result = data->file;
				_g_object_unref0 (data->info);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_it);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->file);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_it);
	}
	data->result = NULL;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 125 "rygel-media-object.vala"
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 300 "rygel-media-object.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 41 "rygel-plugin-loader.vala"
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 41 "rygel-plugin-loader.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, writer, http_server, error);
#line 311 "rygel-media-object.c"
}


#line 129 "rygel-media-object.vala"
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property) {
#line 317 "rygel-media-object.c"
	gint result = 0;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
#line 129 "rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 129 "rygel-media-object.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 129 "rygel-media-object.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 331 "rygel-media-object.c"
	_tmp0_ = property;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props (self, self->id, media_object->id);
#line 133 "rygel-media-object.vala"
			return result;
#line 341 "rygel-media-object.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props (self, ((RygelMediaObject*) self->parent)->id, ((RygelMediaObject*) media_object->parent)->id);
#line 135 "rygel-media-object.vala"
			return result;
#line 350 "rygel-media-object.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props (self, rygel_media_object_get_title (self), rygel_media_object_get_title (media_object));
#line 138 "rygel-media-object.vala"
			return result;
#line 359 "rygel-media-object.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props (self, self->upnp_class, media_object->upnp_class);
#line 140 "rygel-media-object.vala"
			return result;
#line 368 "rygel-media-object.c"
		}
	} else
	switch (0) {
		default:
		{
			result = 0;
#line 143 "rygel-media-object.vala"
			return result;
#line 377 "rygel-media-object.c"
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property) {
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
}


#line 147 "rygel-media-object.vala"
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const char* prop1, const char* prop2) {
#line 390 "rygel-media-object.c"
	gint result = 0;
#line 147 "rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 147 "rygel-media-object.vala"
	g_return_val_if_fail (prop1 != NULL, 0);
#line 147 "rygel-media-object.vala"
	g_return_val_if_fail (prop2 != NULL, 0);
#line 148 "rygel-media-object.vala"
	if (prop1 == NULL) {
#line 400 "rygel-media-object.c"
		result = -1;
#line 149 "rygel-media-object.vala"
		return result;
#line 404 "rygel-media-object.c"
	} else {
#line 150 "rygel-media-object.vala"
		if (prop2 == NULL) {
#line 408 "rygel-media-object.c"
			result = 1;
#line 151 "rygel-media-object.vala"
			return result;
#line 412 "rygel-media-object.c"
		} else {
			result = g_utf8_collate (prop1, prop2);
#line 153 "rygel-media-object.vala"
			return result;
#line 417 "rygel-media-object.c"
		}
	}
}


#line 29 "rygel-media-object.vala"
RygelMediaObject* rygel_media_object_construct (GType object_type) {
#line 425 "rygel-media-object.c"
	RygelMediaObject * self;
#line 29 "rygel-media-object.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 429 "rygel-media-object.c"
	return self;
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent_ref;
#line 51 "rygel-media-object.vala"
	return result;
#line 440 "rygel-media-object.c"
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
#line 55 "rygel-media-object.vala"
	self->parent = value;
#line 56 "rygel-media-object.vala"
	self->priv->_parent_ref = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_parent_ref), _tmp0_);
#line 451 "rygel-media-object.c"
	g_object_notify ((GObject *) self, "parent-ref");
}


const char* rygel_media_object_get_title (RygelMediaObject* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
#line 63 "rygel-media-object.vala"
	return result;
#line 462 "rygel-media-object.c"
}


void rygel_media_object_set_title (RygelMediaObject* self, const char* value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
#line 68 "rygel-media-object.vala"
		_tmp0_ = g_regex_replace_literal (rygel_media_object_real_name_regex, value, (gssize) (-1), 0, g_get_real_name (), 0, &_inner_error_);
#line 478 "rygel-media-object.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 68 "rygel-media-object.vala"
		self->priv->_title = (_tmp1_ = _tmp0_, _g_free0 (self->priv->_title), _tmp1_);
#line 73 "rygel-media-object.vala"
		_tmp2_ = g_regex_replace_literal (rygel_media_object_user_name_regex, self->priv->_title, (gssize) (-1), 0, g_get_user_name (), 0, &_inner_error_);
#line 491 "rygel-media-object.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 73 "rygel-media-object.vala"
		self->priv->_title = (_tmp3_ = _tmp2_, _g_free0 (self->priv->_title), _tmp3_);
#line 78 "rygel-media-object.vala"
		_tmp4_ = g_regex_replace_literal (rygel_media_object_host_name_regex, self->priv->_title, (gssize) (-1), 0, g_get_host_name (), 0, &_inner_error_);
#line 504 "rygel-media-object.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 78 "rygel-media-object.vala"
		self->priv->_title = (_tmp5_ = _tmp4_, _g_free0 (self->priv->_title), _tmp5_);
#line 515 "rygel-media-object.c"
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 84 "rygel-media-object.vala"
			g_assert_not_reached ();
#line 526 "rygel-media-object.c"
			_g_error_free0 (err);
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "title");
}


static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RygelMediaObject * self;
	parent_class = G_OBJECT_CLASS (rygel_media_object_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = RYGEL_MEDIA_OBJECT (obj);
	{
		GeeArrayList* _tmp0_;
#line 100 "rygel-media-object.vala"
		self->uris = (_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->uris), _tmp0_);
#line 551 "rygel-media-object.c"
	}
	return obj;
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_object_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_object_real_compare_by_property;
	G_OBJECT_CLASS (klass)->get_property = rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->constructor = rygel_media_object_constructor;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_inner_error_ = NULL;
	{
		{
			char* _tmp1_;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			GRegex* _tmp4_;
			char* _tmp5_;
			GRegex* _tmp6_;
			GRegex* _tmp7_;
			GRegex* _tmp8_;
			char* _tmp9_;
			GRegex* _tmp10_;
			GRegex* _tmp11_;
			GRegex* _tmp12_;
#line 91 "rygel-media-object.vala"
			_tmp3_ = (_tmp2_ = g_regex_new (_tmp1_ = g_regex_escape_string ("@REALNAME@", -1), 0, 0, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 586 "rygel-media-object.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch39_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
#line 91 "rygel-media-object.vala"
			rygel_media_object_real_name_regex = (_tmp4_ = _tmp3_, _g_regex_unref0 (rygel_media_object_real_name_regex), _tmp4_);
#line 92 "rygel-media-object.vala"
			_tmp7_ = (_tmp6_ = g_regex_new (_tmp5_ = g_regex_escape_string ("@USERNAME@", -1), 0, 0, &_inner_error_), _g_free0 (_tmp5_), _tmp6_);
#line 598 "rygel-media-object.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch39_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
#line 92 "rygel-media-object.vala"
			rygel_media_object_user_name_regex = (_tmp8_ = _tmp7_, _g_regex_unref0 (rygel_media_object_user_name_regex), _tmp8_);
#line 93 "rygel-media-object.vala"
			_tmp11_ = (_tmp10_ = g_regex_new (_tmp9_ = g_regex_escape_string ("@HOSTNAME@", -1), 0, 0, &_inner_error_), _g_free0 (_tmp9_), _tmp10_);
#line 610 "rygel-media-object.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch39_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
#line 93 "rygel-media-object.vala"
			rygel_media_object_host_name_regex = (_tmp12_ = _tmp11_, _g_regex_unref0 (rygel_media_object_host_name_regex), _tmp12_);
#line 620 "rygel-media-object.c"
		}
		goto __finally39;
		__catch39_g_regex_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
#line 95 "rygel-media-object.vala"
				g_assert_not_reached ();
#line 631 "rygel-media-object.c"
				_g_error_free0 (err);
			}
		}
		__finally39:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
	_g_free0 (self->id);
	_g_free0 (self->upnp_class);
	_g_object_unref0 (self->uris);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


/**
 * Represents a media object (container and item).
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




