<xsl:stylesheet version = '1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="text" indent="no" encoding="UTF-8"/>

<xsl:template match="/extension"># This file has been automatically generated by Epiphany

[Epiphany Extension]
Version=1
<xsl:for-each select="/extension/name">
<xsl:text>Name</xsl:text>
<xsl:call-template name="printkey"/>
</xsl:for-each>

<xsl:for-each select="/extension/description">
<xsl:text>Description</xsl:text>
<xsl:call-template name="printkey"/>
</xsl:for-each>
<xsl:text>Authors=</xsl:text>
<xsl:for-each select="/extension/author"><xsl:value-of select="."/>;</xsl:for-each>
URL=<xsl:value-of select="/extension/url"/>

[Loader]
<xsl:choose>
<xsl:when test='/extension/loader/@type="shlib"'>Type=shlib
Library=<xsl:for-each select="/extension/loader/attribute">
<xsl:if test='@name="library"'><xsl:value-of select="."/></xsl:if>
</xsl:for-each>
</xsl:when>
<xsl:when test='/extension/loader/@type="python"'>Type=python
Module=<xsl:for-each select="/extension/loader/attribute">
<xsl:if test='@name="module"'><xsl:value-of select="."/></xsl:if>
</xsl:for-each>
</xsl:when>
</xsl:choose>
<xsl:text>
</xsl:text>
</xsl:template>

<xsl:template name="printkey">
<xsl:if test="@xml:lang">
<xsl:text>[</xsl:text>
<xsl:value-of select="@xml:lang"/>
<xsl:text>]</xsl:text>
</xsl:if>
<xsl:text>=</xsl:text>
<xsl:value-of select="."/>
<xsl:text>
</xsl:text>
</xsl:template>

</xsl:stylesheet>
