# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_v1 import WpImageDescriptionV1


class WpImageDescriptionCreatorParamsV1(Interface):
    """Holder of image description parameters

    This type of object is used for collecting all the parameters required to
    create a
    :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
    object. A complete set of required parameters consists of these properties:
    - transfer characteristic function (tf) - chromaticities of primaries and
    white point (primary color volume)

    The following properties are optional and have a well-defined default if
    not explicitly set: - primary color volume luminance range - reference
    white luminance level - mastering display primaries and white point (target
    color volume) - mastering luminance range

    The following properties are optional and will be ignored if not explicitly
    set: - maximum content light level - maximum frame-average light level

    Each required property must be set exactly once if the client is to create
    an image description. The set requests verify that a property was not
    already set. The create request verifies that all required properties are
    set. There may be several alternative requests for setting each property,
    and in that case the client must choose one of them.

    Once all properties have been set, the create request must be used to
    create the image description object, destroying the creator in the process.
    """

    name = "wp_image_description_creator_params_v1"
    version = 1

    class error(enum.IntEnum):
        incomplete_set = 0
        already_set = 1
        unsupported_feature = 2
        invalid_tf = 3
        invalid_primaries_named = 4
        invalid_luminance = 5


class WpImageDescriptionCreatorParamsV1Proxy(Proxy[WpImageDescriptionCreatorParamsV1]):
    interface = WpImageDescriptionCreatorParamsV1

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def create(self) -> Proxy[WpImageDescriptionV1]:
        """Create the image description object using params

        Create an image description object based on the parameters previously
        set on this object.

        The completeness of the parameter set is verified. If the set is not
        complete, the protocol error incomplete_set is raised. For the
        definition of a complete set, see the description of this interface.

        The protocol error invalid_luminance is raised if any of the following
        requirements is not met: - When max_cll is set, it must be greater than
        min L and less or equal   to max L of the mastering luminance range. -
        When max_fall is set, it must be greater than min L and less or equal
        to max L of the mastering luminance range. - When both max_cll and
        max_fall are set, max_fall must be less or equal   to max_cll.

        If the particular combination of the parameter set is not supported by
        the compositor, the resulting image description object shall
        immediately deliver the :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event with the 'unsupported' cause. If a valid image description was
        created from the parameter set, the :func:`WpImageDescriptionV1.ready()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.ready>`
        event will eventually be sent instead.

        This request destroys the :class:`WpImageDescriptionCreatorParamsV1`
        object.

        The resulting image description object does not allow get_information
        request.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(0, WpImageDescriptionV1)
        return image_description

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_tf_named(self, tf: int) -> None:
        """Named transfer characteristic

        Sets the transfer characteristic using explicitly enumerated named
        functions.

        When the resulting image description is attached to an image, the
        content should be encoded and decoded according to the industry
        standard practices for the transfer characteristic.

        Only names advertised with
        :class:`~pywayland.protocol.color_management_v1.WpColorManagerV1` event
        supported_tf_named are allowed. Other values shall raise the protocol
        error invalid_tf.

        If transfer characteristic has already been set on this object, the
        protocol error already_set is raised.

        :param tf:
            named transfer function
        :type tf:
            `ArgumentType.Uint`
        """
        self._marshal(1, tf)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_tf_power(self, eexp: int) -> None:
        """Transfer characteristic as a power curve

        Sets the color component transfer characteristic to a power curve with
        the given exponent. Negative values are handled by mirroring the
        positive half of the curve through the origin. The valid domain and
        range of the curve are all finite real numbers. This curve represents
        the conversion from electrical to optical color channel values.

        When the resulting image description is attached to an image, the
        content should be encoded with the inverse of the power curve.

        The curve exponent shall be multiplied by 10000 to get the argument
        eexp value to carry the precision of 4 decimals.

        The curve exponent must be at least 1.0 and at most 10.0. Otherwise the
        protocol error invalid_tf is raised.

        If transfer characteristic has already been set on this object, the
        protocol error already_set is raised.

        This request can be used when the compositor advertises
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.set_tf_power.
        Otherwise this request raises the protocol error unsupported_feature.

        :param eexp:
            the exponent * 10000
        :type eexp:
            `ArgumentType.Uint`
        """
        self._marshal(2, eexp)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_primaries_named(self, primaries: int) -> None:
        """Named primaries

        Sets the color primaries and white point using explicitly named sets.
        This describes the primary color volume which is the basis for color
        value encoding.

        Only names advertised with
        :class:`~pywayland.protocol.color_management_v1.WpColorManagerV1` event
        supported_primaries_named are allowed. Other values shall raise the
        protocol error invalid_primaries_named.

        If primaries have already been set on this object, the protocol error
        already_set is raised.

        :param primaries:
            named primaries
        :type primaries:
            `ArgumentType.Uint`
        """
        self._marshal(3, primaries)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_primaries(self, r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """Primaries as chromaticity coordinates

        Sets the color primaries and white point using CIE 1931 xy chromaticity
        coordinates. This describes the primary color volume which is the basis
        for color value encoding.

        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.

        If primaries have already been set on this object, the protocol error
        already_set is raised.

        This request can be used if the compositor advertises
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.set_primaries.
        Otherwise this request raises the protocol error unsupported_feature.

        :param r_x:
            Red x * 1M
        :type r_x:
            `ArgumentType.Int`
        :param r_y:
            Red y * 1M
        :type r_y:
            `ArgumentType.Int`
        :param g_x:
            Green x * 1M
        :type g_x:
            `ArgumentType.Int`
        :param g_y:
            Green y * 1M
        :type g_y:
            `ArgumentType.Int`
        :param b_x:
            Blue x * 1M
        :type b_x:
            `ArgumentType.Int`
        :param b_y:
            Blue y * 1M
        :type b_y:
            `ArgumentType.Int`
        :param w_x:
            White x * 1M
        :type w_x:
            `ArgumentType.Int`
        :param w_y:
            White y * 1M
        :type w_y:
            `ArgumentType.Int`
        """
        self._marshal(4, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_luminances(self, min_lum: int, max_lum: int, reference_lum: int) -> None:
        """Primary color volume luminance range and reference white

        Sets the primary color volume luminance range and the reference white
        luminance level. These values include the minimum display emission and
        ambient flare luminances, assumed to be optically additive and have the
        chromaticity of the primary color volume white point.

        The default luminances from
        https://www.color.org/chardata/rgb/srgb.xalter are - primary color
        volume minimum: 0.2 cd/m² - primary color volume maximum: 80 cd/m² -
        reference white: 80 cd/m²

        Setting a named transfer characteristic can imply other default
        luminances.

        The default luminances get overwritten when this request is used. With
        transfer_function.st2084_pq the given 'max_lum' value is ignored, and
        'max_lum' is taken as 'min_lum' + 10000 cd/m².

        'min_lum' and 'max_lum' specify the minimum and maximum luminances of
        the primary color volume as reproduced by the targeted display.

        'reference_lum' specifies the luminance of the reference white as
        reproduced by the targeted display, and reflects the targeted viewing
        environment.

        Compositors should make sure that all content is anchored, meaning that
        an input signal level of 'reference_lum' on one image description and
        another input signal level of 'reference_lum' on another image
        description should produce the same output level, even though the
        'reference_lum' on both image representations can be different.

        'reference_lum' may be higher than 'max_lum'. In that case reaching the
        reference white output level in image content requires the
        'extended_target_volume' feature support.

        If 'max_lum' or 'reference_lum' are less than or equal to 'min_lum',
        the protocol error invalid_luminance is raised.

        The minimum luminance is multiplied by 10000 to get the argument
        'min_lum' value and carries precision of 4 decimals. The maximum
        luminance and reference white luminance values are unscaled.

        If the primary color volume luminance range and the reference white
        luminance level have already been set on this object, the protocol
        error already_set is raised.

        This request can be used if the compositor advertises
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.set_luminances.
        Otherwise this request raises the protocol error unsupported_feature.

        :param min_lum:
            minimum luminance (cd/m²) * 10000
        :type min_lum:
            `ArgumentType.Uint`
        :param max_lum:
            maximum luminance (cd/m²)
        :type max_lum:
            `ArgumentType.Uint`
        :param reference_lum:
            reference white luminance (cd/m²)
        :type reference_lum:
            `ArgumentType.Uint`
        """
        self._marshal(5, min_lum, max_lum, reference_lum)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_mastering_display_primaries(self, r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """Mastering display primaries as chromaticity coordinates

        Provides the color primaries and white point of the mastering display
        using CIE 1931 xy chromaticity coordinates. This is compatible with the
        SMPTE ST 2086 definition of HDR static metadata.

        The mastering display primaries and mastering display luminances define
        the target color volume.

        If mastering display primaries are not explicitly set, the target color
        volume is assumed to have the same primaries as the primary color
        volume.

        The target color volume is defined by all tristimulus values between
        0.0 and 1.0 (inclusive) of the color space defined by the given
        mastering display primaries and white point. The colorimetry is
        identical between the container color space and the mastering display
        color space, including that no chromatic adaptation is applied even if
        the white points differ.

        The target color volume can exceed the primary color volume to allow
        for a greater color volume with an existing color space definition (for
        example scRGB). It can be smaller than the primary color volume to
        minimize gamut and tone mapping distances for big color spaces (HDR
        metadata).

        To make use of the entire target color volume a suitable pixel format
        has to be chosen (e.g. floating point to exceed the primary color
        volume, or abusing limited quantization range as with xvYCC).

        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.

        If mastering display primaries have already been set on this object,
        the protocol error already_set is raised.

        This request can be used if the compositor advertises
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.set_mastering_display_primaries.
        Otherwise this request raises the protocol error unsupported_feature.
        The advertisement implies support only for target color volumes fully
        contained within the primary color volume.

        If a compositor additionally supports target color volume exceeding the
        primary color volume, it must advertise
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.extended_target_volume.
        If a client uses target color volume exceeding the primary color volume
        and the compositor does not support it, the result is implementation
        defined. Compositors are recommended to detect this case and fail the
        image description gracefully, but it may as well result in color
        artifacts.

        :param r_x:
            Red x * 1M
        :type r_x:
            `ArgumentType.Int`
        :param r_y:
            Red y * 1M
        :type r_y:
            `ArgumentType.Int`
        :param g_x:
            Green x * 1M
        :type g_x:
            `ArgumentType.Int`
        :param g_y:
            Green y * 1M
        :type g_y:
            `ArgumentType.Int`
        :param b_x:
            Blue x * 1M
        :type b_x:
            `ArgumentType.Int`
        :param b_y:
            Blue y * 1M
        :type b_y:
            `ArgumentType.Int`
        :param w_x:
            White x * 1M
        :type w_x:
            `ArgumentType.Int`
        :param w_y:
            White y * 1M
        :type w_y:
            `ArgumentType.Int`
        """
        self._marshal(6, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_mastering_luminance(self, min_lum: int, max_lum: int) -> None:
        """Display mastering luminance range

        Sets the luminance range that was used during the content mastering
        process as the minimum and maximum absolute luminance L. These values
        include the minimum display emission and ambient flare luminances,
        assumed to be optically additive and have the chromaticity of the
        primary color volume white point. This should be compatible with the
        SMPTE ST 2086 definition of HDR static metadata.

        The mastering display primaries and mastering display luminances define
        the target color volume.

        If mastering luminances are not explicitly set, the target color volume
        is assumed to have the same min and max luminances as the primary color
        volume.

        If max L is less than or equal to min L, the protocol error
        invalid_luminance is raised.

        Min L value is multiplied by 10000 to get the argument min_lum value
        and carry precision of 4 decimals. Max L value is unscaled for max_lum.

        This request can be used if the compositor advertises
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.set_mastering_display_primaries.
        Otherwise this request raises the protocol error unsupported_feature.
        The advertisement implies support only for target color volumes fully
        contained within the primary color volume.

        If a compositor additionally supports target color volume exceeding the
        primary color volume, it must advertise
        :func:`WpColorManagerV1.feature()
        <pywayland.protocol.color_management_v1.WpColorManagerV1.feature>`.extended_target_volume.
        If a client uses target color volume exceeding the primary color volume
        and the compositor does not support it, the result is implementation
        defined. Compositors are recommended to detect this case and fail the
        image description gracefully, but it may as well result in color
        artifacts.

        :param min_lum:
            min L (cd/m²) * 10000
        :type min_lum:
            `ArgumentType.Uint`
        :param max_lum:
            max L (cd/m²)
        :type max_lum:
            `ArgumentType.Uint`
        """
        self._marshal(7, min_lum, max_lum)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_max_cll(self, max_cll: int) -> None:
        """Maximum content light level

        Sets the maximum content light level (max_cll) as defined by CTA-861-H.

        max_cll is undefined by default.

        :param max_cll:
            Maximum content light level (cd/m²)
        :type max_cll:
            `ArgumentType.Uint`
        """
        self._marshal(8, max_cll)

    @WpImageDescriptionCreatorParamsV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_max_fall(self, max_fall: int) -> None:
        """Maximum frame-average light level

        Sets the maximum frame-average light level (max_fall) as defined by
        CTA-861-H.

        max_fall is undefined by default.

        :param max_fall:
            Maximum frame-average light level (cd/m²)
        :type max_fall:
            `ArgumentType.Uint`
        """
        self._marshal(9, max_fall)


class WpImageDescriptionCreatorParamsV1Resource(Resource):
    interface = WpImageDescriptionCreatorParamsV1


class WpImageDescriptionCreatorParamsV1Global(Global):
    interface = WpImageDescriptionCreatorParamsV1


WpImageDescriptionCreatorParamsV1._gen_c()
WpImageDescriptionCreatorParamsV1.proxy_class = WpImageDescriptionCreatorParamsV1Proxy
WpImageDescriptionCreatorParamsV1.resource_class = WpImageDescriptionCreatorParamsV1Resource
WpImageDescriptionCreatorParamsV1.global_class = WpImageDescriptionCreatorParamsV1Global
