# This file has been autogenerated by the pywayland scanner

# Copyright © 2021-2023 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlBuffer


class ExtImageCopyCaptureFrameV1(Interface):
    """Image capture frame

    This object represents an image capture frame.

    The client should attach a buffer, damage the buffer, and then send a
    capture request.

    If the capture is successful, the compositor must send the frame metadata
    (transform, damage, presentation_time in any order) followed by the ready
    event.

    If the capture fails, the compositor must send the failed event.
    """

    name = "ext_image_copy_capture_frame_v1"
    version = 1

    class error(enum.IntEnum):
        no_buffer = 1
        invalid_buffer_damage = 2
        already_captured = 3

    class failure_reason(enum.IntEnum):
        unknown = 0
        buffer_constraints = 1
        stopped = 2


class ExtImageCopyCaptureFrameV1Proxy(Proxy[ExtImageCopyCaptureFrameV1]):
    interface = ExtImageCopyCaptureFrameV1

    @ExtImageCopyCaptureFrameV1.request()
    def destroy(self) -> None:
        """Destroy this object

        Destroys the frame. This request can be sent at any time by the client.
        """
        self._marshal(0)
        self._destroy()

    @ExtImageCopyCaptureFrameV1.request(
        Argument(ArgumentType.Object, interface=WlBuffer),
    )
    def attach_buffer(self, buffer: WlBuffer) -> None:
        """Attach buffer to session

        Attach a buffer to the session.

        The :func:`WlBuffer.release()
        <pywayland.protocol.wayland.WlBuffer.release>` request is unused.

        The new buffer replaces any previously attached buffer.

        This request must not be sent after capture, or else the
        already_captured protocol error is raised.

        :param buffer:
        :type buffer:
            :class:`~pywayland.protocol.wayland.WlBuffer`
        """
        self._marshal(1, buffer)

    @ExtImageCopyCaptureFrameV1.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def damage_buffer(self, x: int, y: int, width: int, height: int) -> None:
        """Damage buffer

        Apply damage to the buffer which is to be captured next. This request
        may be sent multiple times to describe a region.

        The client indicates the accumulated damage since this
        :class:`~pywayland.protocol.wayland.WlBuffer` was last captured. During
        capture, the compositor will update the buffer with at least the union
        of the region passed by the client and the region advertised by
        :func:`ExtImageCopyCaptureFrameV1.damage()`.

        When a :class:`~pywayland.protocol.wayland.WlBuffer` is captured for
        the first time, or when the client doesn't track damage, the client
        must damage the whole buffer.

        This is for optimisation purposes. The compositor may use this
        information to reduce copying.

        These coordinates originate from the upper left corner of the buffer.

        If x or y are strictly negative, or if width or height are negative or
        zero, the invalid_buffer_damage protocol error is raised.

        This request must not be sent after capture, or else the
        already_captured protocol error is raised.

        :param x:
            region x coordinate
        :type x:
            `ArgumentType.Int`
        :param y:
            region y coordinate
        :type y:
            `ArgumentType.Int`
        :param width:
            region width
        :type width:
            `ArgumentType.Int`
        :param height:
            region height
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(2, x, y, width, height)

    @ExtImageCopyCaptureFrameV1.request()
    def capture(self) -> None:
        """Capture a frame

        Capture a frame.

        Unless this is the first successful captured frame performed in this
        session, the compositor may wait an indefinite amount of time for the
        source content to change before performing the copy.

        This request may only be sent once, or else the already_captured
        protocol error is raised. A buffer must be attached before this request
        is sent, or else the no_buffer protocol error is raised.
        """
        self._marshal(3)


class ExtImageCopyCaptureFrameV1Resource(Resource):
    interface = ExtImageCopyCaptureFrameV1

    @ExtImageCopyCaptureFrameV1.event(
        Argument(ArgumentType.Uint),
    )
    def transform(self, transform: int) -> None:
        """Buffer transform

        This event is sent before the ready event and holds the transform that
        the compositor has applied to the buffer contents.

        :param transform:
        :type transform:
            `ArgumentType.Uint`
        """
        self._post_event(0, transform)

    @ExtImageCopyCaptureFrameV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def damage(self, x: int, y: int, width: int, height: int) -> None:
        """Buffer damaged region

        This event is sent before the ready event. It may be generated multiple
        times to describe a region.

        The first captured frame in a session will always carry full damage.
        Subsequent frames' damaged regions describe which parts of the buffer
        have changed since the last ready event.

        These coordinates originate in the upper left corner of the buffer.

        :param x:
            damage x coordinate
        :type x:
            `ArgumentType.Int`
        :param y:
            damage y coordinate
        :type y:
            `ArgumentType.Int`
        :param width:
            damage width
        :type width:
            `ArgumentType.Int`
        :param height:
            damage height
        :type height:
            `ArgumentType.Int`
        """
        self._post_event(1, x, y, width, height)

    @ExtImageCopyCaptureFrameV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def presentation_time(self, tv_sec_hi: int, tv_sec_lo: int, tv_nsec: int) -> None:
        """Presentation time of the frame

        This event indicates the time at which the frame is presented to the
        output in system monotonic time. This event is sent before the ready
        event.

        The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
        each component being an unsigned 32-bit value. Whole seconds are in
        tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
        and the additional fractional part in tv_nsec as nanoseconds. Hence,
        for valid timestamps tv_nsec must be in [0, 999999999].

        :param tv_sec_hi:
            high 32 bits of the seconds part of the timestamp
        :type tv_sec_hi:
            `ArgumentType.Uint`
        :param tv_sec_lo:
            low 32 bits of the seconds part of the timestamp
        :type tv_sec_lo:
            `ArgumentType.Uint`
        :param tv_nsec:
            nanoseconds part of the timestamp
        :type tv_nsec:
            `ArgumentType.Uint`
        """
        self._post_event(2, tv_sec_hi, tv_sec_lo, tv_nsec)

    @ExtImageCopyCaptureFrameV1.event()
    def ready(self) -> None:
        """Frame is available for reading

        Called as soon as the frame is copied, indicating it is available for
        reading.

        The buffer may be re-used by the client after this event.

        After receiving this event, the client must destroy the object.
        """
        self._post_event(3)

    @ExtImageCopyCaptureFrameV1.event(
        Argument(ArgumentType.Uint),
    )
    def failed(self, reason: int) -> None:
        """Capture failed

        This event indicates that the attempted frame copy has failed.

        After receiving this event, the client must destroy the object.

        :param reason:
        :type reason:
            `ArgumentType.Uint`
        """
        self._post_event(4, reason)


class ExtImageCopyCaptureFrameV1Global(Global):
    interface = ExtImageCopyCaptureFrameV1


ExtImageCopyCaptureFrameV1._gen_c()
ExtImageCopyCaptureFrameV1.proxy_class = ExtImageCopyCaptureFrameV1Proxy
ExtImageCopyCaptureFrameV1.resource_class = ExtImageCopyCaptureFrameV1Resource
ExtImageCopyCaptureFrameV1.global_class = ExtImageCopyCaptureFrameV1Global
