;/* Copyright 2000, International Business Machines Corporation and others.
; * All Rights Reserved.
; *
; * This software has been released under the terms of the IBM Public
; * License.  For details, see the LICENSE file in the top-level source
; * directory or online at http://www.openafs.org/dl/license10.html
; * event.mc --(mc)--> event.[h|rc] --(logevent.h + event.h)--> afsevent.h
; */
;
;#ifndef OPENAFS_AFSEVENT_H
;#define OPENAFS_AFSEVENT_H
;
;
;/* AFS event.mc format.
; *
; * AFS event messages are grouped by category.  The MessageId of the
; * first message in a given category specifies the starting identifier
; * range for that category; the second and later messages in a category
; * do NOT specify a MessageId value and thus receive the value of the
; * previous message plus one.
; *
; * To add a new message to an existing category, append it to the end of
; * that category.  To create a new category, provide an appropriate
; * comment line and specify a non-conflicting MessageId for the first
; * message in the new category.
; */
;


LanguageNames=(Japanese=1:MSG000001)
MessageIdTypedef=unsigned

;
;/* Test message text */
;

MessageId=0x0001
Severity=Informational
SymbolicName=AFSEVT_SVR_TEST_MSG_NOARGS
Language=Japanese
AFS T[o[ECxgEOEeXgEbZ[WB
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_TEST_MSG_TWOARGS
Language=Japanese
AFS T[o[ECxgEOEeXgEbZ[W (str1: %1, str2: %2)B
.



;
;/* General messages for all AFS server processes */
;

MessageId=0x0101
Severity=Error
SymbolicName=AFSEVT_SVR_FAILED_ASSERT
Language=Japanese
AFS T[o[EvZXɎs܂: s %1 t@C %2B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_NO_INSTALL_DIR
Language=Japanese
%1  AFS \tgEFÃCXg[EfBNg[܂łB
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_WINSOCK_INIT_FAILED
Language=Japanese
%1  Windows Socket Cu[ł܂łB
.



;
;/* AFS BOS control (startup/shutdown) service messages */
;

MessageId=0x0201
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STARTED
Language=Japanese
AFS BOS T[rXn܂B
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STOPPED
Language=Japanese
AFS BOS T[rX~܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_SCM_COMM_FAILED
Language=Japanese
AFS BOS T[rXVXe SCM ƒʐMł܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_HANDLER_REG_FAILED
Language=Japanese
AFS BOS T[rXCxgEnh[o^ł܂BAFS T[o[E\tgEFA\ĂȂ\܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INSUFFICIENT_RESOURCES
Language=Japanese
AFS BOS T[rXKvȃVXeE\[X擾ł܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INTERNAL_ERROR
Language=Japanese
AFS BOS T[rXG[o܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_NO_INSTALL_DIR
Language=Japanese
AFS BOS T[rX AFS \tgEFÃCXg[EfBNg[܂łBAFS T[o[E\tgEFA\ĂȂ\܂B
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_START_FAILED
Language=Japanese
AFS BOS T[rX AFS bosserver n܂͍Ďnł܂łB
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_FAILED
Language=Japanese
AFS BOS T[rX AFS bosserver ~ł܂łBAFS T[o[EvZXׂĎ蓮Œ~Kv܂ (AFS bosserver  afskill R}h SIGQUIT VOi𑗐MĂ݂Ă)B
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_TIMEOUT
Language=Japanese
AFS BOS T[rX AFS bosserver ̒~҂𒆎~܂BT[rXĎnOɁAׂĂ AFS T[o[EvZX~Ă邱Ƃm߂ĂB
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_RESTART
Language=Japanese
AFS BOS T[rX AFS bosserver ĎnĂ܂B
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_EXIT
Language=Japanese
AFS BOS T[rXAAFS bosserver ĎnvȂŏIƂo܂B
.



;
;#endif /* OPENAFS_AFSEVENT_H */
