/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak;

import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import org.junit.Assert;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import se.jiderhamn.HeapDumper;
import se.jiderhamn.classloader.PackagesLoadedOutsideClassLoader;
import se.jiderhamn.classloader.RedefiningClassLoader;
import se.jiderhamn.classloader.ZombieMarker;
import se.jiderhamn.classloader.leak.LeakPreventor;
import se.jiderhamn.classloader.leak.Leaks;

public class JUnitClassloaderRunner
extends BlockJUnit4ClassRunner {
    private static final int HALT_TIME_S = 10;

    public JUnitClassloaderRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        LeakPreventor leakPreventorAnn = method.getMethod().getDeclaringClass().getAnnotation(LeakPreventor.class);
        Class<? extends Runnable> preventorClass = leakPreventorAnn != null ? leakPreventorAnn.value() : null;
        return new SeparateClassLoaderInvokeMethod(method, test, preventorClass, test.getClass().getAnnotation(PackagesLoadedOutsideClassLoader.class));
    }

    public static void forceGc(int n) {
        for (int i = 0; i < n; ++i) {
            JUnitClassloaderRunner.forceGc();
        }
    }

    public static void forceGc() {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        while (ref.get() != null) {
            System.gc();
        }
    }

    private static void waitForHeapDump() throws InterruptedException {
        System.out.println("Waiting 10 seconds to allow for heap dump acquirement");
        System.out.println("Tip: You can search for " + ZombieMarker.class.getName() + " in the dump");
        Thread.sleep(10000L);
    }

    private void dumpHeap(String testName) {
        File surefireReports = this.getSurefireReportsDirectory();
        try {
            File heapDump = surefireReports != null ? new File(surefireReports, testName + ".hprof") : new File(testName + ".hprof");
            HeapDumper.dumpHeap(heapDump, false);
            System.out.println("Heaped dumped to " + heapDump.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Unable to dump heap - not Sun/Oracle JVM?");
        }
    }

    private File getSurefireReportsDirectory() {
        return JUnitClassloaderRunner.getSurefireReportsDirectory(this.getTestClass().getJavaClass());
    }

    private static File getSurefireReportsDirectory(Class<?> clazz) {
        try {
            String absolutePath = clazz.getResource(clazz.getSimpleName() + ".class").toString();
            String relativePath = clazz.getName().replace('.', '/') + ".class";
            String classPath = absolutePath.substring(0, absolutePath.length() - relativePath.length());
            if (classPath.startsWith("jar:")) {
                return null;
            }
            File dir = new File(new URL(classPath).toURI());
            File sureFireReports = new File(dir.getParent(), "surefire-reports");
            if (!sureFireReports.exists() && "test-classes".equals(dir.getName()) && "target".equals(dir.getParentFile().getName())) {
                try {
                    sureFireReports.mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sureFireReports.exists() && sureFireReports.isDirectory() && sureFireReports.canWrite() ? sureFireReports : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <T> T[] appendArrays(T[] arr1, T[] arr2) {
        Object[] output = (Object[])Array.newInstance(arr1.getClass().getComponentType(), arr1.length + arr2.length);
        System.arraycopy(arr1, 0, output, 0, arr1.length);
        System.arraycopy(arr2, 0, output, arr1.length, arr2.length);
        return output;
    }

    private class SeparateClassLoaderInvokeMethod
    extends InvokeMethod {
        private final Method originalMethod;
        private final boolean expectedLeak;
        private final boolean haltBeforeError;
        private final boolean dumpHeapOnError;
        private Class<? extends Runnable> preventorClass;
        private final String[] ignoredPackages;

        private SeparateClassLoaderInvokeMethod(FrameworkMethod testMethod, Object target) {
            this(testMethod, target, null, null);
        }

        private SeparateClassLoaderInvokeMethod(FrameworkMethod testMethod, Object target, Class<? extends Runnable> preventorClass, PackagesLoadedOutsideClassLoader packagesLoadedOutsideClassLoader) {
            super(testMethod, target);
            this.originalMethod = testMethod.getMethod();
            Leaks leakAnn = (Leaks)testMethod.getAnnotation(Leaks.class);
            this.expectedLeak = leakAnn == null || leakAnn.value();
            this.haltBeforeError = leakAnn != null && leakAnn.haltBeforeError();
            this.dumpHeapOnError = leakAnn != null && leakAnn.dumpHeapOnError();
            this.preventorClass = preventorClass;
            this.ignoredPackages = packagesLoadedOutsideClassLoader == null ? null : (packagesLoadedOutsideClassLoader.addToDefaults() ? (String[])JUnitClassloaderRunner.this.appendArrays(RedefiningClassLoader.DEFAULT_IGNORED_PACKAGES, packagesLoadedOutsideClassLoader.packages()) : packagesLoadedOutsideClassLoader.packages());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void evaluate() throws Throwable {
            WeakReference<RedefiningClassLoader> weak;
            ClassLoader clBefore = Thread.currentThread().getContextClassLoader();
            String testName = JUnitClassloaderRunner.this.getTestClass().getName() + '.' + this.originalMethod.getName();
            RedefiningClassLoader myClassLoader = this.ignoredPackages != null ? new RedefiningClassLoader(clBefore, testName, this.ignoredPackages) : new RedefiningClassLoader(clBefore, testName);
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)myClassLoader));
                TestClass myTestClass = new TestClass(myClassLoader.loadClass(JUnitClassloaderRunner.this.getTestClass().getName()));
                Method myMethod = myClassLoader.loadClass(this.originalMethod.getDeclaringClass().getName()).getDeclaredMethod(this.originalMethod.getName(), this.originalMethod.getParameterTypes());
                System.out.println("JUnit used " + JUnitClassloaderRunner.this.getTestClass().getJavaClass().getClassLoader());
                System.out.println("SeparateClassLoaderInvokeMethod used " + myTestClass.getJavaClass().getClassLoader());
                new FrameworkMethod(myMethod).invokeExplosively(myTestClass.getOnlyConstructor().newInstance(new Object[0]), new Object[0]);
                myTestClass = null;
                myMethod = null;
                Thread.currentThread().setContextClassLoader(clBefore);
                weak = new WeakReference<RedefiningClassLoader>(myClassLoader);
                myClassLoader.markAsZombie();
                myClassLoader = null;
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace(System.err);
                    throw new RuntimeException(e.getClass().getName() + ": " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(clBefore);
                    WeakReference<RedefiningClassLoader> weak2 = new WeakReference<RedefiningClassLoader>(myClassLoader);
                    myClassLoader.markAsZombie();
                    myClassLoader = null;
                    JUnitClassloaderRunner.forceGc(3);
                    if (this.expectedLeak) {
                        RedefiningClassLoader redefiningClassLoader = (RedefiningClassLoader)((Object)weak2.get());
                        Assert.assertNotNull((String)"ClassLoader has been garbage collected, while test is expected to leak", (Object)((Object)redefiningClassLoader));
                        if (redefiningClassLoader != null && this.preventorClass != null) {
                            try {
                                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)redefiningClassLoader));
                                Class preventorInLeakedLoader = redefiningClassLoader.loadClass(this.preventorClass.getName());
                                Runnable leakPreventor = (Runnable)preventorInLeakedLoader.newInstance();
                                String leakPreventorName = leakPreventor.toString();
                                leakPreventor.run();
                                leakPreventor = null;
                                preventorInLeakedLoader = null;
                                redefiningClassLoader = null;
                                Thread.currentThread().setContextClassLoader(clBefore);
                                JUnitClassloaderRunner.forceGc(3);
                                boolean leak = weak2.get() != null;
                                if (!leak) throw throwable;
                                String message = "ClassLoader (" + weak2.get() + ") has not been garbage collected, despite running the leak preventor " + leakPreventorName;
                                weak2.clear();
                                this.performErrorActions(testName);
                                Assert.fail((String)message);
                                throw throwable;
                            }
                            catch (Exception e2) {
                                throw new RuntimeException("Leak prevention class " + this.preventorClass.getName() + " could not be used!", e2);
                            }
                            finally {
                                redefiningClassLoader = null;
                                Thread.currentThread().setContextClassLoader(clBefore);
                            }
                        } else {
                            boolean leak = weak2.get() != null;
                            if (!leak) throw throwable;
                            redefiningClassLoader = null;
                            weak2.clear();
                            this.performErrorActions(testName);
                        }
                        throw throwable;
                    } else {
                        boolean leak = weak2.get() != null;
                        if (!leak) throw throwable;
                        String message = "ClassLoader has not been garbage collected " + weak2.get();
                        weak2.clear();
                        this.performErrorActions(testName);
                        Assert.fail((String)message);
                    }
                    throw throwable;
                }
            }
            JUnitClassloaderRunner.forceGc(3);
            if (this.expectedLeak) {
                RedefiningClassLoader redefiningClassLoader = (RedefiningClassLoader)((Object)weak.get());
                Assert.assertNotNull((String)"ClassLoader has been garbage collected, while test is expected to leak", (Object)((Object)redefiningClassLoader));
                if (redefiningClassLoader != null && this.preventorClass != null) {
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)redefiningClassLoader));
                        Class preventorInLeakedLoader = redefiningClassLoader.loadClass(this.preventorClass.getName());
                        Runnable leakPreventor = (Runnable)preventorInLeakedLoader.newInstance();
                        String leakPreventorName = leakPreventor.toString();
                        leakPreventor.run();
                        leakPreventor = null;
                        preventorInLeakedLoader = null;
                        redefiningClassLoader = null;
                        Thread.currentThread().setContextClassLoader(clBefore);
                        JUnitClassloaderRunner.forceGc(3);
                        boolean leak = weak.get() != null;
                        if (!leak) return;
                        String message = "ClassLoader (" + weak.get() + ") has not been garbage collected, despite running the leak preventor " + leakPreventorName;
                        weak.clear();
                        this.performErrorActions(testName);
                        Assert.fail((String)message);
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Leak prevention class " + this.preventorClass.getName() + " could not be used!", e);
                    }
                    finally {
                        redefiningClassLoader = null;
                        Thread.currentThread().setContextClassLoader(clBefore);
                    }
                } else {
                    if (weak.get() == null) return;
                    boolean bl = true;
                    boolean leak = bl;
                    if (!leak) return;
                    redefiningClassLoader = null;
                    weak.clear();
                    this.performErrorActions(testName);
                }
                return;
            } else {
                if (weak.get() == null) return;
                boolean bl = true;
                boolean leak = bl;
                if (!leak) return;
                String message = "ClassLoader has not been garbage collected " + weak.get();
                weak.clear();
                this.performErrorActions(testName);
                Assert.fail((String)message);
            }
            return;
        }

        private void performErrorActions(String testName) throws InterruptedException {
            if (this.dumpHeapOnError) {
                JUnitClassloaderRunner.this.dumpHeap(testName);
            }
            if (this.haltBeforeError) {
                JUnitClassloaderRunner.waitForHeapDump();
            }
        }
    }
}

