/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xwt.tools.ui.designer.editor.event.EventHandler;

public class NewHandlerDialog
extends TitleAreaDialog {
    private EventHandler eventHandler;
    private String handlerName;

    public NewHandlerDialog(EventHandler eventHandler, String initialValue) {
        super(new Shell());
        this.eventHandler = eventHandler;
        this.handlerName = initialValue;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("New Handler Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(composite, 0);
        control.setLayoutData((Object)new GridData(1808));
        control.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(control, 0);
        label.setText("Handler:");
        final Text text = new Text(control, 2048);
        text.setText(this.handlerName);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewHandlerDialog.this.handlerName = text.getText();
                if (NewHandlerDialog.this.handlerName == null) {
                    NewHandlerDialog.this.setErrorMessage("Handler name is null.");
                } else if (NewHandlerDialog.this.eventHandler.exist(NewHandlerDialog.this.handlerName)) {
                    NewHandlerDialog.this.setErrorMessage("Handler existing for current xwt presentation.");
                } else {
                    NewHandlerDialog.this.setErrorMessage(null);
                }
            }
        });
        text.setLayoutData((Object)new GridData(768));
        this.setTitle("New Event Handler");
        this.setMessage("Create a new event handler for current XWT presentation.");
        return composite;
    }

    public String getHandlerName() {
        return this.handlerName;
    }
}

