/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.layouts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class XYFlowLayout
extends XYLayout {
    protected static int fMarginWidth = 10;
    protected static int fMarginHeight = 10;

    protected void layoutIfRequired(IFigure f) {
        for (IFigure child : this.constraints.keySet()) {
            Rectangle constraint = (Rectangle)this.getConstraint(child);
            if (constraint == null || constraint.width != -1 && constraint.height != -1 && (constraint.x != Integer.MIN_VALUE || constraint.y != Integer.MIN_VALUE)) continue;
            this.layout(f);
            return;
        }
    }

    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        this.layoutIfRequired(f);
        Rectangle rect = new Rectangle();
        Rectangle workingRect = new Rectangle();
        for (IFigure child : f.getChildren()) {
            Rectangle r = (Rectangle)this.constraints.get(child);
            if (r == null) continue;
            workingRect.x = r.x == Integer.MIN_VALUE ? child.getBounds().x : r.x;
            int n = workingRect.y = r.y == Integer.MIN_VALUE ? child.getBounds().y : r.y;
            if (r.width == -1 || r.height == -1) {
                Dimension prefSize = child.getPreferredSize();
                workingRect.width = r.width == -1 ? prefSize.width : r.width;
                workingRect.height = r.height == -1 ? prefSize.height : r.height;
            }
            rect.union(r);
        }
        Dimension d = rect.getSize();
        Insets insets = f.getInsets();
        return d.expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    protected void findWhiteSpaceFor(int rIndex, Rectangle[] rects, Rectangle boundingRect) {
        Rectangle tryRect;
        boolean intersects;
        int requestedWidth = rects[rIndex].width + 2 * fMarginWidth;
        int requestedHeight = rects[rIndex].height + 2 * fMarginHeight;
        int leftMost = boundingRect.x;
        int topMost = boundingRect.y;
        int rightMost = boundingRect.x + boundingRect.width;
        if (requestedWidth < boundingRect.width) {
            Rectangle tryRect2;
            int highestBottom = topMost;
            block0: while (true) {
                boolean intersects2;
                int x = leftMost;
                int y = highestBottom;
                highestBottom = Integer.MAX_VALUE;
                do {
                    if (x + requestedWidth >= rightMost) continue block0;
                    intersects2 = false;
                    tryRect2 = new Rectangle(x, y, requestedWidth, requestedHeight);
                    int i = 0;
                    while (i < rects.length) {
                        Rectangle rect = rects[i];
                        if (rect != null && rect.x != Integer.MIN_VALUE && rect.y != Integer.MIN_VALUE && rect.intersects(tryRect2)) {
                            intersects2 = true;
                            x = Math.max(x, rect.x + rect.width);
                            highestBottom = Math.min(highestBottom, rect.y + rect.height);
                        }
                        ++i;
                    }
                } while (intersects2);
                break;
            }
            rects[rIndex].x = tryRect2.x + fMarginWidth;
            rects[rIndex].y = tryRect2.y + fMarginHeight;
            return;
        }
        int y = topMost;
        do {
            intersects = false;
            tryRect = new Rectangle(leftMost, y, requestedWidth, requestedHeight);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = rects[i];
                if (rect != null && rect.x != Integer.MIN_VALUE && rect.y != Integer.MIN_VALUE && rect.intersects(tryRect)) {
                    intersects = true;
                    y = Math.max(y, rect.y + rect.height);
                }
                ++i;
            }
        } while (intersects);
        rects[rIndex].x = tryRect.x + fMarginWidth;
        rects[rIndex].y = tryRect.y + fMarginHeight;
    }

    public void layout(IFigure containerFigure) {
        IFigure f;
        List children = containerFigure.getChildren();
        Rectangle[] newBounds = new Rectangle[children.size()];
        Rectangle containerRectangle = null;
        Point offset = this.getOrigin(containerFigure);
        int i = 0;
        while (i < children.size()) {
            f = (IFigure)children.get(i);
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds != null) {
                bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                if (bounds.width == -1 || bounds.height == -1) {
                    Dimension prefSize = f.getPreferredSize();
                    if (bounds.width == -1) {
                        bounds.width = prefSize.width;
                    }
                    if (bounds.height == -1) {
                        bounds.height = prefSize.height;
                    }
                }
                if (bounds.x != Integer.MIN_VALUE && bounds.y != Integer.MIN_VALUE) {
                    bounds.translate(offset);
                    containerRectangle = containerRectangle != null ? containerRectangle.union(bounds) : bounds.getCopy().setLocation(Math.min(0, bounds.x), Math.min(0, bounds.y));
                }
                newBounds[i] = bounds;
            }
            ++i;
        }
        if (containerRectangle != null) {
            containerRectangle.setSize(Math.max(containerRectangle.width, 1000), Math.max(containerRectangle.height, 1000));
        } else {
            containerRectangle = new Rectangle();
        }
        i = 0;
        while (i < newBounds.length) {
            if (newBounds[i] != null) {
                if (newBounds[i].x == Integer.MIN_VALUE && newBounds[i].y == Integer.MIN_VALUE) {
                    this.findWhiteSpaceFor(i, newBounds, containerRectangle);
                }
                f = (IFigure)children.get(i);
                Rectangle newBound = newBounds[i];
                f.setBounds(newBound);
            }
            ++i;
        }
    }
}

