/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.ceditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xwt.tools.ui.designer.core.ceditor.ISourcePage;

public class SourcePageRegistry {
    private static String EXTENSION_ID = "org.eclipse.xwt.tools.ui.designer.core.sourcePages";
    private static String TARGET_ID = "targetId";
    private static String PAGE = "Page";
    private static String PAGE_CLASS = "class";
    private static final ISourcePage[] EMPTY = new ISourcePage[0];

    public static ISourcePage[] getSourcePages(String editorId) {
        if (editorId == null) {
            return EMPTY;
        }
        return SourcePageRegistry.loadFromExtensions(editorId);
    }

    private static ISourcePage[] loadFromExtensions(String editorId) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        ArrayList<ISourcePage> pages = new ArrayList<ISourcePage>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String attribute = element.getAttribute(TARGET_ID);
            if (editorId.equals(attribute)) {
                IConfigurationElement[] children;
                IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren(PAGE);
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    try {
                        ISourcePage sourcePage = (ISourcePage)child.createExecutableExtension(PAGE_CLASS);
                        pages.add(sourcePage);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return pages.toArray(new ISourcePage[pages.size()]);
    }
}

