/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.core;

import java.lang.reflect.Method;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.annotation.UIBounds;
import org.eclipse.xwt.core.IDynamicBinding;
import org.eclipse.xwt.databinding.BindingMode;
import org.eclipse.xwt.databinding.IBindingContext;
import org.eclipse.xwt.internal.utils.UserData;

public abstract class DynamicBinding
implements IDynamicBinding {
    private Object control;
    private Object host;
    private BindingMode mode = BindingMode.TwoWay;
    private IXWTLoader xwtLoader;
    private String name;
    private IBindingContext bindingContext;
    private String type;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IBindingContext getBindingContext() {
        if (this.bindingContext == null) {
            Object element = this.control == null ? this.host : this.control;
            this.bindingContext = XWT.getBindingContext(element);
        }
        return this.bindingContext;
    }

    @Override
    public Object getHost() {
        return this.host;
    }

    @Override
    public void setHost(Object host) {
        this.host = host;
    }

    @Override
    public void setBindingContext(IBindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    @Override
    public void setControl(Object control) {
        this.control = control;
    }

    @Override
    public Object getControl() {
        return this.control;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public BindingMode getMode() {
        return this.mode;
    }

    public void setMode(BindingMode mode) {
        this.mode = mode;
    }

    public void setXWTLoader(IXWTLoader xwtLoader) {
        this.xwtLoader = xwtLoader;
    }

    protected Object getDataContextHost() {
        Object control = this.getControl();
        if (control == null) {
            return null;
        }
        Object data = UserData.getLocalDataContext(control);
        if (data == null || data == this) {
            if (data == null && UserData.hasLocalData(control, "DataContext")) {
                return control;
            }
            Control parent = UserData.getParent(control);
            if (parent != null) {
                return UserData.getDataContextHost(parent);
            }
            return null;
        }
        if (data != null) {
            return control;
        }
        return UserData.getDataContextHost(control);
    }

    protected Object getDataContext() {
        if (this.control != null) {
            return UserData.getDataContext(this.control);
        }
        return null;
    }

    protected IDataProvider getDataProvider(Object dataContext) {
        if (dataContext != null) {
            if (dataContext instanceof IDataProvider) {
                return (IDataProvider)dataContext;
            }
            return this.xwtLoader.findDataProvider(dataContext);
        }
        return null;
    }

    public IDataProvider getDataProvider() {
        return this.getDataProvider(this.getDataContext());
    }

    protected Rectangle getControlBounds() {
        Widget widget = (Widget)this.getControl();
        if (widget instanceof Control) {
            Control control = (Control)widget;
            return control.getBounds();
        }
        Method drawMethod = this.findBoundsMethod(widget.getClass());
        if (drawMethod != null) {
            try {
                drawMethod.setAccessible(true);
                return (Rectangle)drawMethod.invoke((Object)widget, new Object[0]);
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        Control control = this.findHostControl();
        return control.getBounds();
    }

    protected Control findHostControl() {
        Control host;
        Widget widget = (Widget)this.getControl();
        if (widget instanceof Item) {
            Item item = (Item)widget;
            host = (Control)XWT.findParent(item, Control.class);
        } else if (widget instanceof Control) {
            host = (Control)widget;
        } else {
            throw new XWTException();
        }
        return host;
    }

    private Method findBoundsMethod(Class<?> type) {
        Method method;
        Method[] methodArray = type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method2 = methodArray[n2];
            if (method2.getAnnotation(UIBounds.class) != null && method2.getTypeParameters().length == 0 && method2.getReturnType() == Rectangle.class) {
                return method2;
            }
            ++n2;
        }
        Class<?> supertype = type.getSuperclass();
        if (supertype != null && supertype != Widget.class && (method = this.findBoundsMethod(supertype)) != null) {
            return method;
        }
        Class<?>[] classArray = type.getInterfaces();
        int n3 = classArray.length;
        n = 0;
        while (n < n3) {
            Class<?> anInterface = classArray[n];
            Method method3 = this.findBoundsMethod(anInterface);
            if (method3 != null) {
                return method3;
            }
            ++n;
        }
        try {
            Method method4 = type.getDeclaredMethod("getBounds", new Class[0]);
            if (method4.getReturnType() == Rectangle.class) {
                return method4;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

