/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.xaml.impl;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xwt.tools.ui.xaml.Comment;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.xwt.tools.ui.xaml.XamlPackage;
import org.eclipse.xwt.tools.ui.xaml.impl.AnnotatedObjectImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XamlNodeImpl
extends AnnotatedObjectImpl
implements XamlNode {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected static final String NAMESPACE_EDEFAULT = null;
    protected String namespace = NAMESPACE_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected EList<XamlElement> childNodes;
    protected EList<XamlAttribute> attributes;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected EList<Comment> comments;
    protected static final Object WIDGET_EDEFAULT = null;
    protected Object widget = WIDGET_EDEFAULT;

    protected XamlNodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XamlPackage.Literals.XAML_NODE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.equals(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getPrefix() {
        if (this.prefix == null && this.namespace != null && this.getOwnerDocument() != null) {
            EMap<String, String> declaredNamespaces = this.getOwnerDocument().getDeclaredNamespaces();
            for (String key : declaredNamespaces.keySet()) {
                if (!this.namespace.equals(declaredNamespaces.get((Object)key))) continue;
                this.prefix = key;
                break;
            }
        }
        return this.prefix;
    }

    @Override
    public void setPrefix(String newPrefix) {
        if (this.equals(this.prefix, newPrefix)) {
            return;
        }
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    boolean equals(Object source, Object target) {
        return source == null && target == null || source != null && source.equals(target);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        if (this.equals(this.name, newNamespace)) {
            return;
        }
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.equals(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public EList<XamlElement> getChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new EObjectContainmentEList(XamlElement.class, (InternalEObject)this, 5);
        }
        return this.childNodes;
    }

    @Override
    public EList<XamlAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EObjectContainmentEList(XamlAttribute.class, (InternalEObject)this, 6);
        }
        return this.attributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        if (this.equals(this.id, newId)) {
            return;
        }
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public EList<Comment> getComments() {
        if (this.comments == null) {
            this.comments = new EObjectContainmentEList(Comment.class, (InternalEObject)this, 8);
        }
        return this.comments;
    }

    @Override
    public Object getWidget() {
        return this.widget;
    }

    @Override
    public void setWidget(Object newWidget) {
        Object oldWidget = this.widget;
        this.widget = newWidget;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldWidget, this.widget));
        }
    }

    @Override
    public XamlAttribute getAttribute(String name, String namespace) {
        if (name == null || namespace == null) {
            return null;
        }
        EList<XamlAttribute> attributes = this.getAttributes();
        for (XamlAttribute attribute : attributes) {
            String attrName = attribute.getName();
            String attrNS = attribute.getNamespace();
            if (!name.equalsIgnoreCase(attrName) || !namespace.equalsIgnoreCase(attrNS)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public XamlAttribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.getAttribute(name, this.namespace);
    }

    @Override
    public XamlElement getChild(String name, String namespace) {
        if (name == null) {
            return null;
        }
        EList<XamlElement> children = this.getChildren(namespace);
        for (XamlElement element : children) {
            if (!name.equalsIgnoreCase(element.getName()) || !this.equals(namespace, element.getNamespace())) continue;
            return element;
        }
        return null;
    }

    public EList<XamlElement> getChildren(String namespace) {
        BasicEList children = new BasicEList();
        EList<XamlElement> all = this.getChildNodes();
        for (XamlElement element : all) {
            if ((namespace != null || element.getNamespace() != null) && (namespace == null || !namespace.equals(element.getNamespace()))) continue;
            children.add((Object)element);
        }
        return children;
    }

    @Override
    public XamlElement getChild(String name) {
        if (name == null) {
            return null;
        }
        String ns = this.getNamespace();
        XamlDocument ownerDocument = this.getOwnerDocument();
        if (ownerDocument != null) {
            ns = ownerDocument.getDeclaredNamespace(null);
        }
        return this.getChild(name, ns);
    }

    @Override
    public XamlElement getChild(int index) {
        try {
            return (XamlElement)this.getChildNodes().get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public XamlDocument getOwnerDocument() {
        EObject container = this.eContainer();
        while (container != null) {
            if (container instanceof XamlDocument) {
                return (XamlDocument)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    @Override
    public EList<String> attributeNames() {
        BasicEList attributeNames = new BasicEList();
        EList<XamlAttribute> attributes = this.getAttributes();
        for (XamlAttribute attribute : attributes) {
            String name = attribute.getName();
            if (attributeNames.contains((Object)name)) continue;
            attributeNames.add((Object)name);
        }
        return attributeNames;
    }

    @Override
    public EList<String> attributeNames(String namespace) {
        BasicEList attributeNames = new BasicEList();
        if (namespace != null) {
            EList<XamlAttribute> attributes = this.getAttributes();
            for (XamlAttribute attribute : attributes) {
                String name = attribute.getName();
                String ns = attribute.getNamespace();
                if (attributeNames.contains((Object)name) || !namespace.equals(ns)) continue;
                attributeNames.add((Object)name);
            }
        }
        return attributeNames;
    }

    @Override
    public EList<String> attributeNamespaces() {
        BasicEList attributeNamespaces = new BasicEList();
        EList<XamlAttribute> attributes = this.getAttributes();
        for (XamlAttribute attribute : attributes) {
            String ns = attribute.getNamespace();
            if (attributeNamespaces.contains((Object)ns)) continue;
            attributeNamespaces.add((Object)ns);
        }
        return attributeNamespaces;
    }

    @Override
    public XamlNode getParent() {
        if (this.eContainer() instanceof XamlNode) {
            return (XamlNode)this.eContainer();
        }
        return null;
    }

    @Override
    public Node generate(Document document, Map<String, Object> options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFlatValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getChildNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getComments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getPrefix();
            }
            case 3: {
                return this.getNamespace();
            }
            case 4: {
                return this.getValue();
            }
            case 5: {
                return this.getChildNodes();
            }
            case 6: {
                return this.getAttributes();
            }
            case 7: {
                return this.getId();
            }
            case 8: {
                return this.getComments();
            }
            case 9: {
                return this.getWidget();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setPrefix((String)newValue);
                return;
            }
            case 3: {
                this.setNamespace((String)newValue);
                return;
            }
            case 4: {
                this.setValue((String)newValue);
                return;
            }
            case 5: {
                this.getChildNodes().clear();
                this.getChildNodes().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setId((String)newValue);
                return;
            }
            case 8: {
                this.getComments().clear();
                this.getComments().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setWidget(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 3: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 4: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 5: {
                this.getChildNodes().clear();
                return;
            }
            case 6: {
                this.getAttributes().clear();
                return;
            }
            case 7: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 8: {
                this.getComments().clear();
                return;
            }
            case 9: {
                this.setWidget(WIDGET_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 3: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 4: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 5: {
                return this.childNodes != null && !this.childNodes.isEmpty();
            }
            case 6: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 7: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 8: {
                return this.comments != null && !this.comments.isEmpty();
            }
            case 9: {
                return WIDGET_EDEFAULT == null ? this.widget != null : !WIDGET_EDEFAULT.equals(this.widget);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", prefix: ");
        result.append(this.prefix);
        result.append(", namespace: ");
        result.append(this.namespace);
        result.append(", value: ");
        result.append(this.value);
        result.append(", id: ");
        result.append(this.id);
        result.append(", widget: ");
        result.append(this.widget);
        result.append(')');
        return result.toString();
    }

    protected String getQualifiedName() {
        return this.getQualifiedName(this.name);
    }

    protected String getQualifiedName(String name) {
        if (this.prefix != null) {
            return this.prefix + ":" + name;
        }
        return name;
    }
}

