/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections;

import org.eclipse.gef.EditPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutDataType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.AssistancePageFactory;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.IAssistantPage;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public class LayoutDataSection
extends AbstractAttributeSection {
    private IAssistantPage layoutDataPage;
    private Composite pageArea;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this._createControls(parent, aTabbedPropertySheetPage);
        ExpandableComposite expandable = this.getWidgetFactory().createExpandableComposite(parent, 66);
        expandable.setText("Values");
        expandable.setExpanded(true);
        ToolBar toolBar = new ToolBar((Composite)expandable, 0x800000);
        toolBar.setBackground(parent.getDisplay().getSystemColor(1));
        ToolItem clearAction = new ToolItem(toolBar, 8);
        clearAction.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        clearAction.setToolTipText("Clear setting values.");
        clearAction.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LayoutDataSection.this.clearValues();
            }
        });
        expandable.setTextClient((Control)toolBar);
        this.pageArea = this.getWidgetFactory().createComposite((Composite)expandable);
        this.pageArea.setLayout((Layout)new FillLayout());
        expandable.setClient((Control)this.pageArea);
        WidgetEditPart editPart = this.getEditPart();
        if (editPart != null) {
            this.refresh();
        }
    }

    protected void clearValues() {
        if (this.layoutDataPage != null) {
            this.layoutDataPage.performDefault();
        }
    }

    public void doRefresh() {
        LayoutDataType layoutDataType = LayoutsHelper.getLayoutDataType((EditPart)this.getEditPart());
        if (layoutDataType == LayoutDataType.Unknown) {
            return;
        }
        if (this.layoutDataPage == null) {
            this.layoutDataPage = AssistancePageFactory.createPage(layoutDataType);
            if (this.layoutDataPage != null) {
                this.layoutDataPage.getControl(this.pageArea);
                this.pageArea.layout();
            }
        }
        if (this.layoutDataPage != null) {
            this.layoutDataPage.setEditPart((EditPart)this.getEditPart());
        }
    }

    protected Control createSection(Composite parent) {
        return null;
    }

    protected String getAttributeName() {
        return "layoutData";
    }

    protected String getNewValue(Event event) {
        return null;
    }
}

