/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.outline.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.editor.outline.commands.MoveCommand;
import org.eclipse.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.xwt.tools.ui.designer.editor.palette.EntryHelper;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class MoveOnCommand
extends MoveCommand {
    public MoveOnCommand(IStructuredSelection source, Object target, int operation) {
        super(source, target, operation);
    }

    public boolean canExecute() {
        boolean canExecute = super.canExecute();
        if (!canExecute) {
            return false;
        }
        IStructuredSelection sourceNodes = this.getSource();
        for (Object element : sourceNodes) {
            XamlNode sourceNode = null;
            if (element instanceof Entry) continue;
            if (!(element instanceof XamlNode)) {
                return false;
            }
            sourceNode = (XamlNode)element;
            XamlNode sourceParent = sourceNode.getParent();
            if (sourceParent == null) {
                return false;
            }
            if (sourceParent != this.getTarget()) continue;
            return false;
        }
        return true;
    }

    protected void collectCommands(CompoundCommand command) {
        IStructuredSelection sourceNodes = this.getSource();
        XamlNode target = this.getTarget();
        for (Object element : sourceNodes) {
            XamlNode sourceNode = null;
            sourceNode = element instanceof Entry ? EntryHelper.getNode((Entry)element) : (XamlNode)element;
            if (!CreateReqHelper.canCreate(target, sourceNode)) continue;
            XamlNode newChild = null;
            newChild = sourceNode.eContainer() != null ? (XamlNode)EcoreUtil.copy((EObject)sourceNode) : sourceNode;
            command.add((Command)new AddNewChildCommand(target, newChild));
            if (!this.isMove() || sourceNode.eContainer() == null) continue;
            command.add((Command)new DeleteCommand(sourceNode));
        }
    }
}

