/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsl.participants;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.filepath.IFilePathExpression;
import org.eclipse.lemminx.extensions.filepath.IFilePathSupportParticipant;
import org.eclipse.lemminx.extensions.filepath.settings.FilePathExpression;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.FilesUtils;

public class XSLFilePathSupportParticipant
implements IFilePathSupportParticipant {
    private static final List<IFilePathExpression> XSL_FILE_PATH_EXPRESSIONS = Arrays.asList(new XSLFilePathExpression("include/@href"), new XSLFilePathExpression("import/@href"));

    @Override
    public List<IFilePathExpression> collectFilePathExpressions(DOMDocument document) {
        if (!DOMUtils.isXSL(document)) {
            return Collections.emptyList();
        }
        return XSL_FILE_PATH_EXPRESSIONS;
    }

    private static class XSLFilePathExpression
    extends FilePathExpression {
        public XSLFilePathExpression(String xpath) {
            super(xpath);
        }

        @Override
        protected boolean acceptFile(Path path) {
            return DOMUtils.isXSL(FilesUtils.getFileName(path));
        }
    }
}

