/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewFilterReferenceAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemRefreshAction
extends SystemBaseAction {
    private IStructuredSelection _selection = null;

    public SystemRefreshAction(Shell parent) {
        super(SystemResources.ACTION_REFRESH_LABEL, SystemResources.ACTION_REFRESH_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.refresh_navIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.build");
        this.setHelp("org.eclipse.rse.ui.actn0017");
        this.setAvailableOffline(true);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        this._selection = selection;
        Iterator iter = this._selection.iterator();
        while (enable && iter.hasNext()) {
            Object obj = iter.next();
            ISystemViewElementAdapter adapter = this.getViewAdapter(obj);
            if (adapter == null || adapter.showRefresh(obj)) continue;
            enable = false;
        }
        return enable;
    }

    public void run() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (this._selection != null) {
            Object obj;
            Iterator it;
            Object parent;
            ISubSystem subsys;
            HashSet localItems = new HashSet();
            HashSet remoteItems = new HashSet();
            Vector<String> namesToSelect = new Vector<String>();
            Iterator iter = this._selection.iterator();
            while (iter.hasNext()) {
                ISystemViewElementAdapter adapter;
                Object obj2 = iter.next();
                if (obj2 instanceof ISystemContainer) {
                    ((ISystemContainer)obj2).markStale(true);
                }
                if ((adapter = this.getViewAdapter(obj2)) != null) {
                    String absoluteName;
                    Object itemToRefresh = obj2;
                    subsys = adapter.getSubSystem(obj2);
                    if (subsys != null && adapter.supportsDeferredQueries(subsys) && !(adapter instanceof SystemViewFilterReferenceAdapter) && !adapter.hasChildren((IAdaptable)obj2) && (parent = adapter.getParent(obj2)) != null) {
                        itemToRefresh = parent;
                    }
                    if ((absoluteName = adapter.getAbsoluteName(obj2)) != null) {
                        remoteItems.add(itemToRefresh);
                        namesToSelect.add(absoluteName);
                        continue;
                    }
                    if (localItems.contains(obj2)) continue;
                    localItems.add(obj2);
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(obj2, 82, obj2));
                    continue;
                }
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(obj2, 82, obj2));
            }
            localItems.clear();
            boolean itemsChanged = true;
            while (remoteItems.size() > 1 && itemsChanged) {
                itemsChanged = false;
                it = remoteItems.iterator();
                while (it.hasNext()) {
                    obj = it.next();
                    ISystemViewElementAdapter adapter = this.getViewAdapter(obj);
                    parent = adapter.getParent(obj);
                    if (!remoteItems.contains(parent)) continue;
                    it.remove();
                    itemsChanged = true;
                }
            }
            it = remoteItems.iterator();
            while (it.hasNext()) {
                obj = it.next();
                subsys = this.getViewAdapter(obj).getSubSystem(obj);
                if (subsys != null) {
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(obj, 85, namesToSelect));
                    continue;
                }
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(obj, 82, obj));
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(namesToSelect, 101, null));
            }
        } else if (this.viewer != null && this.viewer instanceof ISystemResourceChangeListener) {
            sr.fireEvent((ISystemResourceChangeListener)this.viewer, (ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)sr, 83, null));
        } else {
            sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)sr, 83, null));
        }
    }
}

