/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAgentClient
implements SshAgent {
    private static final Logger LOG = LoggerFactory.getLogger(SshAgentClient.class);
    private static final int MAX_NUMBER_OF_KEYS = 2048;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Connector connector;

    public SshAgentClient(Connector connector) {
        this.connector = connector;
    }

    private boolean open(boolean debugging) throws IOException {
        boolean connected;
        if (this.closed.get()) {
            if (debugging) {
                LOG.debug("SSH agent connection already closed");
            }
            return false;
        }
        boolean bl = connected = this.connector != null && this.connector.connect();
        if (!connected && debugging) {
            LOG.debug("No SSH agent (SSH_AUTH_SOCK not set)");
        }
        return connected;
    }

    public void close() throws IOException {
        if (!this.closed.getAndSet(true) && this.connector != null) {
            this.connector.close();
        }
    }

    public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
        boolean debugging = LOG.isDebugEnabled();
        if (!this.open(debugging)) {
            return Collections.emptyList();
        }
        if (debugging) {
            LOG.debug("Requesting identities from SSH agent");
        }
        try {
            Buffer reply = this.rpc((byte)11);
            byte cmd = reply.getByte();
            if (cmd != 12) {
                throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, SshAgentConstants.getCommandMessageName((int)cmd)));
            }
            int numberOfKeys = reply.getInt();
            if (numberOfKeys < 0 || numberOfKeys > 2048) {
                throw new SshException(MessageFormat.format(SshdText.get().sshAgentWrongNumberOfKeys, Integer.toString(numberOfKeys)));
            }
            if (numberOfKeys == 0) {
                if (debugging) {
                    LOG.debug("SSH agent has no keys");
                }
                return Collections.emptyList();
            }
            if (debugging) {
                LOG.debug("Got {} key(s) from the SSH agent", (Object)Integer.toString(numberOfKeys));
            }
            boolean tracing = LOG.isTraceEnabled();
            ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>> keys = new ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>>(numberOfKeys);
            int i = 0;
            while (i < numberOfKeys) {
                PublicKey key = reply.getPublicKey();
                String comment = reply.getString();
                if (tracing) {
                    LOG.trace("Got SSH agent {} key: {} {}", new Object[]{KeyUtils.getKeyType((Key)key), KeyUtils.getFingerPrint((PublicKey)key), comment});
                }
                keys.add(new AbstractMap.SimpleImmutableEntry<PublicKey, String>(key, comment));
                ++i;
            }
            return keys;
        }
        catch (BufferException e) {
            throw new SshException(SshdText.get().sshAgentShortReadBuffer, (Throwable)e);
        }
    }

    public Map.Entry<String, byte[]> sign(SessionContext session, PublicKey key, String algorithm, byte[] data) throws IOException {
        Buffer reply;
        byte cmd;
        String signatureAlgorithm;
        boolean debugging = LOG.isDebugEnabled();
        String keyType = KeyUtils.getKeyType((Key)key);
        if (algorithm != null) {
            if (!KeyUtils.getCanonicalKeyType((String)algorithm).equals(keyType)) {
                throw new IllegalArgumentException(MessageFormat.format(SshdText.get().invalidSignatureAlgorithm, algorithm, keyType));
            }
            signatureAlgorithm = algorithm;
        } else {
            signatureAlgorithm = keyType;
        }
        if (!this.open(debugging)) {
            return null;
        }
        int flags = 0;
        switch (signatureAlgorithm) {
            case "rsa-sha2-512-cert-v01@openssh.com": 
            case "rsa-sha2-512": {
                flags = 4;
                break;
            }
            case "rsa-sha2-256": 
            case "rsa-sha2-256-cert-v01@openssh.com": {
                flags = 2;
                break;
            }
        }
        ByteArrayBuffer msg = new ByteArrayBuffer();
        msg.putInt(0L);
        msg.putByte((byte)13);
        msg.putPublicKey(key);
        msg.putBytes(data);
        msg.putInt((long)flags);
        if (debugging) {
            LOG.debug("sign({}): signing request to SSH agent for {} key, {} signature; flags={}", new Object[]{session, keyType, signatureAlgorithm, Integer.toString(flags)});
        }
        if ((cmd = (reply = this.rpc((byte)13, msg.getCompactData())).getByte()) != 14) {
            throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, SshAgentConstants.getCommandMessageName((int)cmd)));
        }
        try {
            ByteArrayBuffer signatureReply = new ByteArrayBuffer(reply.getBytes());
            String actualAlgorithm = signatureReply.getString();
            byte[] signature = signatureReply.getBytes();
            if (LOG.isTraceEnabled()) {
                LOG.trace("sign({}): signature reply from SSH agent for {} key: {} signature={}", new Object[]{session, keyType, actualAlgorithm, BufferUtils.toHex((char)':', (byte[])signature)});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("sign({}): signature reply from SSH agent for {} key, {} signature", new Object[]{session, keyType, actualAlgorithm});
            }
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(actualAlgorithm, signature);
        }
        catch (BufferException e) {
            throw new SshException(SshdText.get().sshAgentShortReadBuffer, (Throwable)e);
        }
    }

    private Buffer rpc(byte command, byte[] message) throws IOException {
        return new ByteArrayBuffer(this.connector.rpc(command, message));
    }

    private Buffer rpc(byte command) throws IOException {
        return new ByteArrayBuffer(this.connector.rpc(command));
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public void addIdentity(KeyPair key, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeIdentity(PublicKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIdentities() throws IOException {
        throw new UnsupportedOperationException();
    }
}

