/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.util.LfsFactory;

public class RepositoriesViewPropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof RepositoryTreeNode)) {
            return false;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)receiver;
        Collection<? extends Repository> repositories = null;
        if (node instanceof RepositoryGroupNode) {
            repositories = ((RepositoryGroupNode)node).getRepositories();
        } else {
            Repository repository = node.getRepository();
            if (repository != null) {
                repositories = Collections.singleton(repository);
            }
        }
        if (repositories == null || repositories.isEmpty()) {
            return false;
        }
        boolean value = true;
        for (Repository repository : repositories) {
            value &= this.internalTest(node, repository, property);
        }
        boolean bl = GitTraceLocation.PROPERTIESTESTER.isActive();
        if (bl) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.PROPERTIESTESTER.getLocation(), "prop " + property + " of " + receiver + " = " + value + ", expected = " + expectedValue);
        }
        return this.computeResult(expectedValue, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalTest(RepositoryTreeNode node, Repository repository, String property) {
        if (property.equals("isBare")) {
            return repository.isBare();
        }
        if (property.equals("containsHead")) {
            return this.containsHead(repository);
        }
        if (ResourcePropertyTester.testRepositoryState(repository, property)) {
            return true;
        }
        if (property.equals("isRefCheckedOut")) {
            Ref ref2;
            if (node instanceof BranchHierarchyNode) {
                try {
                    for (Ref ref2 : ((BranchHierarchyNode)node).getChildRefsRecursive()) {
                        if (!this.isRefCheckedOut(repository, ref2)) continue;
                        return true;
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (!(node.getObject() instanceof Ref)) {
                return false;
            }
            ref2 = (Ref)node.getObject();
            return this.isRefCheckedOut(repository, ref2);
        }
        if (property.equals("isLocalBranch")) {
            if (!(node.getObject() instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)node.getObject();
            return ref.getName().startsWith("refs/heads/");
        }
        if (property.equals("fetchExists") && node instanceof RemoteNode) {
            RemoteConfig rconfig;
            String configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)SelectionRepositoryStateCache.INSTANCE.getConfig(repository), configName);
            }
            catch (URISyntaxException e2) {
                return false;
            }
            if (rconfig.getFetchRefSpecs().isEmpty()) return false;
            if (rconfig.getURIs().isEmpty()) return false;
            return true;
        }
        if (property.equals("pushExists") && node instanceof RemoteNode) {
            RemoteConfig rconfig;
            String configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)SelectionRepositoryStateCache.INSTANCE.getConfig(repository), configName);
            }
            catch (URISyntaxException e2) {
                return false;
            }
            if (rconfig.getPushRefSpecs().isEmpty()) return false;
            if (!rconfig.getPushURIs().isEmpty()) return true;
            if (rconfig.getURIs().isEmpty()) return false;
            return true;
        }
        if (property.equals("canStash")) {
            RepositoryState state = SelectionRepositoryStateCache.INSTANCE.getRepositoryState(repository);
            return state.canCommit();
        }
        if (property.equals("canMerge")) {
            RepositoryState state = SelectionRepositoryStateCache.INSTANCE.getRepositoryState(repository);
            if (state != RepositoryState.SAFE) {
                return false;
            }
            String branch = SelectionRepositoryStateCache.INSTANCE.getFullBranchName(repository);
            if (branch != null) return branch.startsWith("refs/heads/");
            return false;
        }
        if ("isSubmodule".equals(property)) {
            RepositoryTreeNode parent = node.getParent();
            if (parent == null) return false;
            if (parent.getType() != RepositoryTreeNodeType.SUBMODULES) return false;
            return true;
        }
        if (!"canEnableLfs".equals(property)) return false;
        if (!LfsFactory.getInstance().isAvailable()) return false;
        if (!LfsFactory.getInstance().isEnabled(repository)) return true;
        return false;
    }

    private boolean isRefCheckedOut(Repository repository, Ref ref) {
        if (ref.getName().startsWith("refs/")) {
            return ref.getName().equals(SelectionRepositoryStateCache.INSTANCE.getFullBranchName(repository));
        }
        if (ref.getName().equals("HEAD")) {
            return true;
        }
        String leafname = ref.getLeaf().getName();
        if (leafname.startsWith("refs/") && leafname.equals(SelectionRepositoryStateCache.INSTANCE.getFullBranchName(repository))) {
            return true;
        }
        ObjectId objectId = ref.getLeaf().getObjectId();
        return objectId != null && objectId.equals((AnyObjectId)SelectionRepositoryStateCache.INSTANCE.getHead(repository));
    }

    private boolean containsHead(Repository repository) {
        return SelectionRepositoryStateCache.INSTANCE.getHead(repository) != null;
    }
}

