/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.soap.SOAPBinding;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractDocumentBareValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class DocBareNonVoidNoOutParametersRuleTest
extends AbstractDocumentBareValidationTest {
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n");
        classContents.append("public class MyClass {\n\n\t");
        classContents.append("public String noOut(String in, @WebParam(name=\"out\", mode=WebParam.Mode.OUT) ");
        classContents.append("String out) {\n\t\treturn \"txt\";\n\t}\n\n}");
        return classContents.toString();
    }

    public void testNonVoidNoOUTParameterRule() {
        try {
            DocBareNonVoidNoOutParametersRuleTest.assertNotNull((Object)this.annotation);
            DocBareNonVoidNoOutParametersRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("noOut", new String[]{"QString;", "QString; "});
            DocBareNonVoidNoOutParametersRuleTest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, SOAPBinding.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToMethod((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            DocBareNonVoidNoOutParametersRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            DocBareNonVoidNoOutParametersRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            DocBareNonVoidNoOutParametersRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            DocBareNonVoidNoOutParametersRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            DocBareNonVoidNoOutParametersRuleTest.assertEquals((Object)JAXWSCoreMessages.DOC_BARE_NON_VOID_RETURN_NO_INOUT_OUT_PARAMETER, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            DocBareNonVoidNoOutParametersRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            DocBareNonVoidNoOutParametersRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            DocBareNonVoidNoOutParametersRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

