/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;

public class PersistenceXmlResourceProvider
extends AbstractXmlResourceProvider {
    public static PersistenceXmlResourceProvider getXmlResourceProvider(IFile file) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider_(file.getProject(), file.getFullPath().toString());
    }

    public static PersistenceXmlResourceProvider getXmlResourceProvider(IProject project, String deployLocation) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider_(project, JptCorePlugin.getDeploymentURI(project, deployLocation));
    }

    public static PersistenceXmlResourceProvider getDefaultXmlResourceProvider(IProject project) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider(project, "META-INF/persistence.xml");
    }

    private static PersistenceXmlResourceProvider getXmlResourceProvider_(IProject project, String location) {
        return new PersistenceXmlResourceProvider(project, (IPath)new Path(location));
    }

    public PersistenceXmlResourceProvider(IProject project) {
        this(project, (IPath)new Path("META-INF/persistence.xml"));
    }

    public PersistenceXmlResourceProvider(IProject project, IPath filePath) {
        super(project, filePath, JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE);
    }

    protected void populateRoot() {
        XmlPersistence persistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        persistence.setVersion("1.0");
        XmlPersistenceUnit persistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        persistenceUnit.setName(this.getProject().getName());
        persistence.getPersistenceUnits().add((Object)persistenceUnit);
        this.getResourceContents().add((Object)persistence);
    }
}

