/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceGeneratorAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceSequenceGeneratorAnnotation
extends SourceGeneratorAnnotation
implements SequenceGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SequenceGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> SEQUENCE_NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("sequenceName");
    private final AnnotationElementAdapter<String> sequenceNameAdapter = this.buildAdapter(SEQUENCE_NAME_ADAPTER);
    private String sequenceName;

    public SourceSequenceGeneratorAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SequenceGenerator";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.sequenceName = this.buildSequenceName(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setSequenceName(this.buildSequenceName(astRoot));
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void setSequenceName(String sequenceName) {
        if (this.attributeValueHasNotChanged(this.sequenceName, sequenceName)) {
            return;
        }
        String old = this.sequenceName;
        this.sequenceName = sequenceName;
        this.sequenceNameAdapter.setValue(sequenceName);
        this.firePropertyChanged("sequenceName", old, sequenceName);
    }

    private String buildSequenceName(CompilationUnit astRoot) {
        return this.sequenceNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSequenceNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SEQUENCE_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean sequenceNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SEQUENCE_NAME_ADAPTER, pos, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }
}

