/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentAttribute;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePersistentType
extends SourcePersistentMember<Type>
implements JavaResourcePersistentType {
    private String name;
    private String qualifiedName;
    private String superclassQualifiedName;
    private boolean abstract_;
    private final Vector<JavaResourcePersistentType> types = new Vector();
    private final Vector<JavaResourcePersistentAttribute> fields = new Vector();
    private final Vector<JavaResourcePersistentAttribute> methods = new Vector();
    private AccessType access;

    static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private SourcePersistentType(JavaResourceCompilationUnit javaResourceCompilationUnit, Type type) {
        super(javaResourceCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.name = this.buildName(astRoot);
        this.qualifiedName = this.buildQualifiedName(astRoot);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(astRoot);
        this.abstract_ = this.buildAbstract(astRoot);
        this.initializeTypes(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
        this.access = this.buildAccess();
    }

    private void initializeTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.member).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(td, occurrence, astRoot));
            ++n2;
        }
    }

    private void initializeFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.member).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    private void initializeMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.member).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    @Override
    Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildTypeMappingAnnotation(this, (Type)this.member, mappingAnnotationName);
    }

    @Override
    Annotation buildSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildTypeSupportingAnnotation(this, (Type)this.member, annotationName);
    }

    @Override
    Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeSupportingAnnotation(this, annotationName);
    }

    @Override
    ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().typeSupportingAnnotationNames();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName(astRoot));
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            field.resolveTypes(astRoot);
        }
        this.updateMethods(astRoot);
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            method.resolveTypes(astRoot);
        }
        for (JavaResourcePersistentType type : this.getTypes()) {
            type.resolveTypes(astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? null : binding.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    private String buildQualifiedName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? null : binding.getQualifiedName();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void setSuperclassQualifiedName(String superclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = superclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, superclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        if (binding == null) {
            return null;
        }
        ITypeBinding superclass = binding.getSuperclass();
        return superclass == null ? null : superclass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    private boolean buildAbstract(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? false : Modifier.isAbstract((int)binding.getModifiers());
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    private void setAccess(AccessType access) {
        AccessType old = this.access;
        this.access = access;
        this.firePropertyChanged("access", (Object)old, (Object)access);
    }

    private AccessType buildAccess() {
        return JPTTools.buildAccess(this);
    }

    @Override
    public boolean hasAnyAttributePersistenceAnnotations() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().hasAnyPersistenceAnnotations()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        return new CloneIterator(this.types);
    }

    private Iterable<JavaResourcePersistentType> getTypes() {
        return new CloneIterable(this.types);
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        return new TreeIterator<JavaResourcePersistentType>((JavaResourcePersistentType)this){

            protected Iterator<? extends JavaResourcePersistentType> children(JavaResourcePersistentType type) {
                return type.types();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        return this.persistableMembers(this.types());
    }

    private JavaResourcePersistentType getType(String typeName, int occurrence) {
        for (JavaResourcePersistentType type : this.getTypes()) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    private void addType(JavaResourcePersistentType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    private void removeTypes(Collection<JavaResourcePersistentType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return new CloneIterator(this.fields);
    }

    private Iterable<JavaResourcePersistentAttribute> getFields() {
        return new CloneIterable(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return this.persistableMembers(this.fields());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.persistableFields()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.FIELD;
            }
        };
    }

    private void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return new CloneIterator(this.methods);
    }

    private Iterable<JavaResourcePersistentAttribute> getMethods() {
        return new CloneIterable(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return this.persistableMembers(this.methods());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.persistableProperties()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.PROPERTY;
            }
        };
    }

    private JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType specifiedAccess) {
        if (specifiedAccess == null) {
            throw new IllegalArgumentException("specified access is null");
        }
        return specifiedAccess == AccessType.FIELD ? this.persistableAttributesForFieldAccessType() : this.persistableAttributesForPropertyAccessType();
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForFieldAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistablePropertiesWithSpecifiedPropertyAccess()});
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForPropertyAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableProperties(), this.persistableFieldsWithSpecifiedFieldAccess()});
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setName(this.buildName(astRoot));
        this.setQualifiedName(this.buildQualifiedName(astRoot));
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName(astRoot));
        this.setAbstract(this.buildAbstract(astRoot));
        this.updateTypes(astRoot);
        this.updateFields(astRoot);
        this.updateMethods(astRoot);
        this.setAccess(this.buildAccess());
    }

    private void updateTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.member).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        HashSet<JavaResourcePersistentType> typesToRemove = new HashSet<JavaResourcePersistentType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourcePersistentType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(typeDeclaration, occurrence, astRoot));
            } else {
                typesToRemove.remove(type);
                type.update(astRoot);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    private JavaResourcePersistentType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentType.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.member, nestedTypeDeclaration, occurrence, astRoot);
    }

    private void updateFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.member).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> fieldsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourcePersistentAttribute field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.update(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    private JavaResourcePersistentAttribute buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.member, fieldName, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    private void updateMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.member).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> methodsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            JavaResourcePersistentAttribute method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.update(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    private JavaResourcePersistentAttribute buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.member, signature, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    private static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    private static class CounterMap {
        private final HashMap<Object, Counter> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            Counter counter = this.counters.get(o);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.count();
        }
    }
}

