/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceBasicAnnotation
extends SourceAnnotation<Attribute>
implements BasicAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Basic");
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceBasicAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private Boolean optional;
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceBasicAnnotation.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;

    public SourceBasicAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.optionalAdapter = new ShortCircuitAnnotationElementAdapter<Boolean>(attribute, OPTIONAL_ADAPTER);
        this.fetchAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, FETCH_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.optional = this.buildOptional(astRoot);
        this.fetch = this.buildFetch(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setOptional(this.buildOptional(astRoot));
        this.setFetch(this.buildFetch(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.fetch);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasNotChanged(this.optional, optional)) {
            return;
        }
        Boolean old = this.optional;
        this.optional = optional;
        this.optionalAdapter.setValue(optional);
        this.firePropertyChanged("optional", old, optional);
    }

    protected Boolean buildOptional(CompilationUnit astRoot) {
        return this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasNotChanged((Object)this.fetch, (Object)fetch)) {
            return;
        }
        FetchType old = this.fetch;
        this.fetch = fetch;
        this.fetchAdapter.setValue(FetchType.toJavaAnnotationValue(fetch));
        this.firePropertyChanged("fetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(DECLARATION_ANNOTATION_ADAPTER, "optional", false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }
}

