/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetInstallDelegate
implements IDelegate,
JpaFacetDataModelProperties {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor = this.nonNullMonitor(monitor);
        try {
            this.execute_(project, fv, config, monitor);
        }
        finally {
            monitor.done();
        }
    }

    void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IDataModel dataModel = (IDataModel)config;
        JptCorePlugin.setJpaPlatformId(project, dataModel.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
        JptCorePlugin.setConnectionProfileName(project, dataModel.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            JptCorePlugin.setUserOverrideDefaultCatalogName(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG"));
        }
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            JptCorePlugin.setUserOverrideDefaultSchemaName(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA"));
        }
        this.addDbDriverLibraryToClasspath(javaProject, dataModel, monitor);
        JptCorePlugin.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        JptCorePlugin.setDefaultJpaPlatformId(dataModel.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
        ((LibraryInstallDelegate)dataModel.getProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
    }

    private void addDbDriverLibraryToClasspath(IJavaProject javaProject, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        if (!dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return;
        }
        String driverName = dataModel.getStringProperty("JpaFacetDataModelProperties.DB_DRIVER_NAME");
        IClasspathContainer container = JptDbPlugin.instance().buildDriverClasspathContainerFor(driverName);
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)container.getPath());
        this.addClasspathEntryToProject(entry, javaProject, monitor);
    }

    private void addClasspathEntryToProject(IClasspathEntry classpathEntry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        Object[] classpath = javaProject.getRawClasspath();
        if (CollectionTools.contains((Object[])classpath, (Object)classpathEntry)) {
            return;
        }
        int len = classpath.length;
        IClasspathEntry[] newClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(classpath, 0, newClasspath, 0, len);
        newClasspath[len] = classpathEntry;
        javaProject.setRawClasspath(newClasspath, monitor);
    }

    private IProgressMonitor nonNullMonitor(IProgressMonitor monitor) {
        return monitor != null ? monitor : new NullProgressMonitor();
    }
}

