/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractXmlContextNode
implements PersistenceXml {
    protected JpaXmlResource persistenceXmlResource;
    protected Persistence persistence;

    public GenericPersistenceXml(JpaRootContextNode parent, JpaXmlResource resource) {
        super(parent);
        if (!resource.getContentType().isKindOf(JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Resource " + resource + " must have persistence xml content type");
        }
        this.persistenceXmlResource = resource;
        if (resource.getRootObject() != null) {
            this.persistence = this.buildPersistence((XmlPersistence)resource.getRootObject());
        }
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.persistenceXmlResource;
    }

    @Override
    public IResource getResource() {
        return this.persistenceXmlResource.getFile();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public IContentType getContentType() {
        return JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE;
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public Persistence addPersistence() {
        if (this.persistence != null) {
            throw new IllegalStateException();
        }
        XmlPersistence xmlPersistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        this.persistence = this.buildPersistence(xmlPersistence);
        this.persistenceXmlResource.getContents().add((Object)xmlPersistence);
        this.firePropertyChanged("persistence", null, this.persistence);
        return this.persistence;
    }

    @Override
    public void removePersistence() {
        if (this.persistence == null) {
            throw new IllegalStateException();
        }
        this.getJpaFile(this.persistenceXmlResource.getFile()).removeRootStructureNode(this.persistenceXmlResource);
        this.persistence.dispose();
        Persistence oldPersistence = this.persistence;
        this.persistence = null;
        XmlPersistence xmlPersistence = (XmlPersistence)this.persistenceXmlResource.getRootObject();
        this.persistenceXmlResource.getContents().remove((Object)xmlPersistence);
        this.firePropertyChanged("persistence", oldPersistence, null);
    }

    protected void setPersistence(Persistence newPersistence) {
        Persistence oldPersistence = this.persistence;
        this.persistence = newPersistence;
        this.firePropertyChanged("persistence", oldPersistence, newPersistence);
    }

    @Override
    public void update(JpaXmlResource persistenceResource) {
        XmlPersistence oldXmlPersistence = this.persistence == null ? null : this.persistence.getXmlPersistence();
        XmlPersistence newXmlPersistence = (XmlPersistence)persistenceResource.getRootObject();
        this.persistenceXmlResource = persistenceResource;
        if (oldXmlPersistence != newXmlPersistence && this.persistence != null) {
            this.getJpaFile(this.persistenceXmlResource.getFile()).removeRootStructureNode(this.persistenceXmlResource);
            this.persistence.dispose();
            this.setPersistence(null);
        }
        if (newXmlPersistence != null) {
            if (this.persistence != null) {
                this.getJpaFile(this.persistenceXmlResource.getFile()).addRootStructureNode(this.persistenceXmlResource, this.persistence);
                this.persistence.update(newXmlPersistence);
            } else {
                this.setPersistence(this.buildPersistence(newXmlPersistence));
            }
        } else {
            if (this.persistence != null) {
                this.getJpaFile(this.persistenceXmlResource.getFile()).removeRootStructureNode(this.persistenceXmlResource);
                this.persistence.dispose();
            }
            this.setPersistence(null);
        }
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.persistence != null) {
            this.persistence.postUpdate();
        }
    }

    protected Persistence buildPersistence(XmlPersistence xmlPersistence) {
        return this.getJpaFactory().buildPersistence(this, xmlPersistence);
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        throw new UnsupportedOperationException("No Persistence Unit in this context");
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.persistence.containsOffset(textOffset)) {
            return this.persistence.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.persistence == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", this));
            return;
        }
        this.persistence.validate(messages, reporter);
    }

    @Override
    public void dispose() {
        this.persistence.dispose();
    }
}

