/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.JarFileRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnit
extends AbstractXmlContextNode
implements PersistenceUnit {
    protected XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final Vector<MappingFileRef> specifiedMappingFileRefs = new Vector();
    protected MappingFileRef impliedMappingFileRef;
    protected final Vector<JarFileRef> jarFileRefs = new Vector();
    protected final Vector<ClassRef> specifiedClassRefs = new Vector();
    protected final Vector<ClassRef> impliedClassRefs = new Vector();
    protected Boolean specifiedExcludeUnlistedClasses;
    protected final Vector<PersistenceUnit.Property> properties = new Vector();
    protected final Vector<Generator> generators = new Vector();
    protected final Vector<Query> queries = new Vector();
    protected final Set<String> rootEntities = new HashSet<String>();
    protected AccessType defaultAccess;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected boolean defaultCascadePersist;

    protected AbstractPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent);
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.buildSpecifiedTransactionType();
        this.defaultTransactionType = this.buildDefaultTransactionType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.initializeProperties();
        this.initializeJarFileRefs();
        this.initializeSpecifiedClassRefs();
        this.initializeMappingFileRefs();
        this.initializeImpliedClassRefs();
        this.initializePersistenceUnitDefaults();
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("generators");
        nonUpdateAspectNames.add("queries");
    }

    protected void initializeJarFileRefs() {
        for (XmlJarFileRef xmlJarFileRef : this.xmlPersistenceUnit.getJarFiles()) {
            this.jarFileRefs.add(this.buildJarFileRef(xmlJarFileRef));
        }
    }

    protected void initializeProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            return;
        }
        for (XmlProperty xmlProperty : xmlProperties.getProperties()) {
            this.properties.add(this.buildProperty(xmlProperty));
        }
    }

    protected void initializeSpecifiedClassRefs() {
        for (XmlJavaClassRef xmlJavaClassRef : this.xmlPersistenceUnit.getClasses()) {
            this.specifiedClassRefs.add(this.buildClassRef(xmlJavaClassRef));
        }
    }

    protected void initializeMappingFileRefs() {
        for (XmlMappingFileRef xmlMappingFileRef : this.xmlPersistenceUnit.getMappingFiles()) {
            this.specifiedMappingFileRefs.add(this.buildSpecifiedMappingFileRef(xmlMappingFileRef));
        }
        if (!this.impliedMappingFileIsSpecified() && this.impliedMappingFileExists()) {
            this.impliedMappingFileRef = this.buildImpliedMappingFileRef();
        }
    }

    protected void initializeImpliedClassRefs() {
        if (!this.excludesUnlistedClasses()) {
            this.initializeImpliedClassRefs_();
        }
    }

    protected void initializeImpliedClassRefs_() {
        Iterator<String> stream = this.getJpaProject().annotatedClassNames();
        while (stream.hasNext()) {
            String typeName = stream.next();
            if (this.specifiesPersistentType(typeName)) continue;
            this.impliedClassRefs.add(this.buildClassRef(typeName));
        }
    }

    protected void initializePersistenceUnitDefaults() {
        MappingFilePersistenceUnitDefaults defaults = this.getDefaults();
        this.defaultAccess = this.buildDefaultAccess(defaults);
        this.defaultCatalog = this.buildDefaultCatalog(defaults);
        this.defaultSchema = this.buildDefaultSchema(defaults);
        this.defaultCascadePersist = this.buildDefaultCascadePersist(defaults);
    }

    @Override
    public Persistence getParent() {
        return (Persistence)super.getParent();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.persistenceUnit";
    }

    @Override
    public IContentType getContentType() {
        return this.getParent().getContentType();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            stream.next().dispose();
        }
        stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            ((MappingFileRef)((Object)stream.next())).dispose();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.xmlPersistenceUnit.setName(name);
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.specifiedTransactionType != null ? this.specifiedTransactionType : this.defaultTransactionType;
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType specifiedTransactionType) {
        PersistenceUnitTransactionType old = this.specifiedTransactionType;
        this.specifiedTransactionType = specifiedTransactionType;
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(specifiedTransactionType));
        this.firePropertyChanged("specifiedTransactionType", (Object)old, (Object)specifiedTransactionType);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType defaultTransactionType) {
        PersistenceUnitTransactionType old = this.defaultTransactionType;
        this.defaultTransactionType = defaultTransactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)old, (Object)defaultTransactionType);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.xmlPersistenceUnit.setDescription(description);
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        String old = this.provider;
        this.provider = provider;
        this.xmlPersistenceUnit.setProvider(provider);
        this.firePropertyChanged("provider", old, provider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String jtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = jtaDataSource;
        this.xmlPersistenceUnit.setJtaDataSource(jtaDataSource);
        this.firePropertyChanged("jtaDataSource", old, jtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String nonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = nonJtaDataSource;
        this.xmlPersistenceUnit.setNonJtaDataSource(nonJtaDataSource);
        this.firePropertyChanged("nonJtaDataSource", old, nonJtaDataSource);
    }

    @Override
    public ListIterator<MappingFileRef> mappingFileRefs() {
        return this.impliedMappingFileRef == null ? this.specifiedMappingFileRefs() : this.combinedMappingFileRefs();
    }

    protected ListIterator<MappingFileRef> combinedMappingFileRefs() {
        return new CompositeListIterator(this.specifiedMappingFileRefs(), (Object)this.impliedMappingFileRef);
    }

    @Override
    public int mappingFileRefsSize() {
        return this.impliedMappingFileRef == null ? this.specifiedMappingFileRefsSize() : this.combinedMappingFileRefsSize();
    }

    protected int combinedMappingFileRefsSize() {
        return this.specifiedMappingFileRefsSize() + 1;
    }

    @Override
    public Iterator<MappingFileRef> mappingFileRefsContaining(final String typeName) {
        return new FilteringIterator<MappingFileRef, MappingFileRef>(this.mappingFileRefs()){

            protected boolean accept(MappingFileRef mappingFileRef) {
                return mappingFileRef.getPersistentType(typeName) != null;
            }
        };
    }

    @Override
    public ListIterator<MappingFileRef> specifiedMappingFileRefs() {
        return new CloneListIterator(this.specifiedMappingFileRefs);
    }

    @Override
    public int specifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefs.size();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef() {
        return this.addSpecifiedMappingFileRef(this.specifiedMappingFileRefs.size());
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index) {
        XmlMappingFileRef xmlMappingFileRef = this.buildXmlMappingFileRef();
        MappingFileRef mappingFileRef = this.buildSpecifiedMappingFileRef(xmlMappingFileRef);
        this.specifiedMappingFileRefs.add(index, mappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        this.fireItemAdded("specifiedMappingFileRefs", index, mappingFileRef);
        return mappingFileRef;
    }

    protected XmlMappingFileRef buildXmlMappingFileRef() {
        return PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        MappingFileRef mappingFileRef = this.specifiedMappingFileRefs.remove(index);
        mappingFileRef.dispose();
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
        this.fireItemRemoved("specifiedMappingFileRefs", index, mappingFileRef);
    }

    protected void addSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        this.addItemToList(mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    protected void removeSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        mappingFileRef.dispose();
        this.removeItemFromList(mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef setImpliedMappingFileRef() {
        if (this.impliedMappingFileRef != null) {
            throw new IllegalStateException("The implied mapping file ref is already set.");
        }
        this.impliedMappingFileRef = this.buildImpliedMappingFileRef();
        this.firePropertyChanged("impliedMappingFileRef", null, this.impliedMappingFileRef);
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef buildImpliedMappingFileRef() {
        return this.getJpaFactory().buildImpliedMappingFileRef(this);
    }

    protected void unsetImpliedMappingFileRef() {
        if (this.impliedMappingFileRef == null) {
            throw new IllegalStateException("The implied mapping file ref is already unset.");
        }
        MappingFileRef old = this.impliedMappingFileRef;
        this.impliedMappingFileRef.dispose();
        this.impliedMappingFileRef = null;
        this.firePropertyChanged("impliedMappingFileRef", old, null);
    }

    @Override
    public ListIterator<JarFileRef> jarFileRefs() {
        return new CloneListIterator(this.jarFileRefs);
    }

    @Override
    public int jarFileRefsSize() {
        return this.jarFileRefs.size();
    }

    @Override
    public JarFileRef addJarFileRef() {
        return this.addJarFileRef(this.jarFileRefs.size());
    }

    @Override
    public JarFileRef addJarFileRef(int index) {
        XmlJarFileRef xmlJarFileRef = this.buildXmlJarFileRef();
        JarFileRef jarFileRef = this.buildJarFileRef(xmlJarFileRef);
        this.jarFileRefs.add(index, jarFileRef);
        this.xmlPersistenceUnit.getJarFiles().add(index, (Object)xmlJarFileRef);
        this.fireItemAdded("jarFileRefs", index, jarFileRef);
        return jarFileRef;
    }

    protected XmlJarFileRef buildXmlJarFileRef() {
        return PersistenceFactory.eINSTANCE.createXmlJarFileRef();
    }

    @Override
    public void removeJarFileRef(JarFileRef jarFileRef) {
        this.removeJarFileRef(this.jarFileRefs.indexOf(jarFileRef));
    }

    @Override
    public void removeJarFileRef(int index) {
        JarFileRef jarFileRef = this.jarFileRefs.remove(index);
        jarFileRef.dispose();
        this.xmlPersistenceUnit.getJarFiles().remove(index);
        this.fireItemRemoved("jarFileRefs", index, jarFileRef);
    }

    protected void addJarFileRef_(JarFileRef jarFileRef) {
        this.addItemToList(jarFileRef, this.jarFileRefs, "jarFileRefs");
    }

    protected void removeJarFileRef_(JarFileRef jarFileRef) {
        jarFileRef.dispose();
        this.removeItemFromList(jarFileRef, this.jarFileRefs, "jarFileRefs");
    }

    @Override
    public Iterator<ClassRef> classRefs() {
        return new CompositeIterator(new Iterator[]{this.specifiedClassRefs(), this.impliedClassRefs()});
    }

    @Override
    public int classRefsSize() {
        return this.specifiedClassRefs.size() + this.impliedClassRefs.size();
    }

    @Override
    public ListIterator<ClassRef> specifiedClassRefs() {
        return new CloneListIterator(this.specifiedClassRefs);
    }

    @Override
    public int specifiedClassRefsSize() {
        return this.specifiedClassRefs.size();
    }

    @Override
    public ClassRef addSpecifiedClassRef() {
        return this.addSpecifiedClassRef(this.specifiedClassRefs.size());
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index) {
        XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef();
        ClassRef classRef = this.buildClassRef(xmlClassRef);
        this.specifiedClassRefs.add(index, classRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        this.fireItemAdded("specifiedClassRefs", index, classRef);
        return classRef;
    }

    protected XmlJavaClassRef buildXmlJavaClassRef() {
        return PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefs.indexOf(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        ClassRef classRef = this.specifiedClassRefs.remove(index);
        classRef.dispose();
        this.xmlPersistenceUnit.getClasses().remove(index);
        this.fireItemRemoved("specifiedClassRefs", index, classRef);
    }

    protected void addSpecifiedClassRef_(ClassRef classRef) {
        this.addItemToList(classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    protected void removeSpecifiedClassRef_(ClassRef classRef) {
        classRef.dispose();
        this.removeItemFromList(classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    @Override
    public Iterator<ClassRef> impliedClassRefs() {
        return new CloneIterator(this.impliedClassRefs);
    }

    @Override
    public int impliedClassRefsSize() {
        return this.impliedClassRefs.size();
    }

    protected ClassRef addImpliedClassRef(String className) {
        ClassRef classRef = this.buildClassRef(className);
        this.addItemToCollection(classRef, this.impliedClassRefs, "impliedClassRefs");
        return classRef;
    }

    protected ClassRef buildClassRef(String className) {
        return this.getJpaFactory().buildClassRef((PersistenceUnit)this, className);
    }

    protected void removeImpliedClassRef(ClassRef classRef) {
        classRef.dispose();
        this.removeItemFromCollection(classRef, this.impliedClassRefs, "impliedClassRefs");
    }

    @Override
    public boolean excludesUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses != null ? this.specifiedExcludeUnlistedClasses.booleanValue() : this.getDefaultExcludeUnlistedClasses();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean specifiedExcludeUnlistedClasses) {
        Boolean old = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = specifiedExcludeUnlistedClasses;
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", old, specifiedExcludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return false;
    }

    @Override
    public ListIterator<PersistenceUnit.Property> properties() {
        return new CloneListIterator(this.properties);
    }

    protected Iterable<PersistenceUnit.Property> getProperties() {
        return new CloneIterable(this.properties);
    }

    @Override
    public int propertiesSize() {
        return this.properties.size();
    }

    @Override
    public PersistenceUnit.Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterator<PersistenceUnit.Property> propertiesWithNamePrefix(final String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            throw new NullPointerException();
        }
        return new FilteringIterator<PersistenceUnit.Property, PersistenceUnit.Property>(this.properties()){

            protected boolean accept(PersistenceUnit.Property property) {
                String pName = property.getName();
                return pName != null && pName.startsWith(propertyNamePrefix);
            }
        };
    }

    @Override
    public PersistenceUnit.Property addProperty() {
        return this.addProperty(this.properties.size());
    }

    @Override
    public PersistenceUnit.Property addProperty(int index) {
        return this.addProperty(this.buildXmlProperty(), index);
    }

    protected XmlProperty buildXmlProperty() {
        return PersistenceFactory.eINSTANCE.createXmlProperty();
    }

    protected PersistenceUnit.Property addProperty(XmlProperty xmlProperty, int index) {
        PersistenceUnit.Property property = this.buildProperty(xmlProperty);
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            xmlProperties = this.buildXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        this.properties.add(index, property);
        xmlProperties.getProperties().add(index, (Object)xmlProperty);
        this.fireItemAdded("properties", index, property);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected PersistenceUnit.Property buildProperty(XmlProperty xmlProperty) {
        return this.getJpaFactory().buildProperty(this, xmlProperty);
    }

    protected XmlProperties buildXmlProperties() {
        return PersistenceFactory.eINSTANCE.createXmlProperties();
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.setProperty(propertyName, value, false);
    }

    @Override
    public void setProperty(String propertyName, String value, boolean duplicatePropertyNamesAllowed) {
        PersistenceUnit.Property prev = this.getProperty(propertyName);
        if (prev == null) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (duplicatePropertyNamesAllowed) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (value == null) {
            this.removeProperty(prev);
        } else {
            prev.setValue(value);
        }
    }

    protected void addProperty(String propertyName, String value) {
        PersistenceUnit.Property property = this.addProperty();
        property.setName(propertyName);
        property.setValue(value);
    }

    @Override
    public void removeProperty(PersistenceUnit.Property property) {
        this.removeProperty(this.properties.indexOf(property));
    }

    @Override
    public void removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name: " + propertyName);
    }

    @Override
    public void removeProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName()) || !value.equals(property.getValue())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name/value pair: " + propertyName + " = " + value);
    }

    protected void removeProperty(int index) {
        PersistenceUnit.Property removedProperty = this.properties.remove(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        this.fireItemRemoved("properties", index, removedProperty);
        if (removedProperty.getName() != null) {
            this.propertyRemoved(removedProperty.getName());
        }
    }

    protected void addProperty_(int index, PersistenceUnit.Property property) {
        this.addItemToList(index, property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
    }

    protected void removeProperty_(int index) {
        this.removeProperty_(this.properties.get(index));
    }

    protected void removeProperty_(PersistenceUnit.Property property) {
        this.removeItemFromList(property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyRemoved(property.getName());
        }
    }

    protected void moveProperty_(int index, PersistenceUnit.Property property) {
        this.moveItemInList(index, this.properties.indexOf(property), this.properties, "properties");
    }

    @Override
    public void propertyNameChanged(String oldPropertyName, String newPropertyName, String value) {
        if (oldPropertyName == null && value == null) {
            return;
        }
        if (oldPropertyName != null) {
            this.propertyRemoved(oldPropertyName);
        }
        if (newPropertyName != null) {
            this.propertyAdded(newPropertyName, value);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
    }

    public void propertyAdded(String propertyName, String value) {
        this.propertyValueChanged(propertyName, value);
    }

    public void propertyRemoved(String propertyName) {
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType defaultAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = defaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)defaultAccess);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String defaultCatalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = defaultCatalog;
        this.firePropertyChanged("defaultCatalog", old, defaultCatalog);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String defaultSchema) {
        String old = this.defaultSchema;
        this.defaultSchema = defaultSchema;
        this.firePropertyChanged("defaultSchema", old, defaultSchema);
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean defaultCascadePersist) {
        boolean old = this.defaultCascadePersist;
        this.defaultCascadePersist = defaultCascadePersist;
        this.firePropertyChanged("defaultCascadePersist", old, defaultCascadePersist);
    }

    @Override
    public ListIterator<Generator> generators() {
        return new CloneListIterator(this.generators);
    }

    @Override
    public int generatorsSize() {
        return this.generators.size();
    }

    @Override
    public void addGenerator(Generator generator) {
        this.generators.add(generator);
    }

    @Override
    public String[] uniqueGeneratorNames() {
        HashSet<String> names = new HashSet<String>(this.generators.size());
        this.addNonNullGeneratorNamesTo(names);
        return names.toArray(new String[names.size()]);
    }

    protected void addNonNullGeneratorNamesTo(Set<String> names) {
        ListIterator<Generator> stream = this.generators();
        while (stream.hasNext()) {
            String generatorName = ((Generator)stream.next()).getName();
            if (generatorName == null) continue;
            names.add(generatorName);
        }
    }

    @Override
    public ListIterator<Query> queries() {
        return new CloneListIterator(this.queries);
    }

    @Override
    public int queriesSize() {
        return this.queries.size();
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    @Override
    public void addRootWithSubEntities(String entityName) {
        this.rootEntities.add(entityName);
    }

    @Override
    public boolean isRootWithSubEntities(String entityName) {
        return this.rootEntities.contains(entityName);
    }

    @Override
    public void update(XmlPersistenceUnit xpu) {
        this.xmlPersistenceUnit = xpu;
        this.generators.clear();
        this.queries.clear();
        this.rootEntities.clear();
        this.setName(xpu.getName());
        this.setSpecifiedTransactionType(this.buildSpecifiedTransactionType());
        this.setDefaultTransactionType(this.buildDefaultTransactionType());
        this.setDescription(xpu.getDescription());
        this.setProvider(xpu.getProvider());
        this.setJtaDataSource(xpu.getJtaDataSource());
        this.setNonJtaDataSource(xpu.getNonJtaDataSource());
        this.updateJarFileRefs();
        this.updateSpecifiedClassRefs();
        this.updateMappingFileRefs();
        this.updateImpliedClassRefs();
        this.setSpecifiedExcludeUnlistedClasses(xpu.getExcludeUnlistedClasses());
        this.updateProperties();
        this.updatePersistenceUnitDefaults();
        this.fireListChanged("generators");
        this.fireListChanged("queries");
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        for (ClassRef classRef : CollectionTools.iterable(this.specifiedClassRefs())) {
            classRef.postUpdate();
        }
        for (ClassRef classRef : CollectionTools.iterable(this.impliedClassRefs())) {
            classRef.postUpdate();
        }
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.specifiedMappingFileRefs())) {
            mappingFileRef.postUpdate();
        }
        if (this.impliedMappingFileRef != null) {
            this.impliedMappingFileRef.postUpdate();
        }
    }

    protected PersistenceUnitTransactionType buildSpecifiedTransactionType() {
        return PersistenceUnitTransactionType.fromXmlResourceModel(this.xmlPersistenceUnit.getTransactionType());
    }

    protected PersistenceUnitTransactionType buildDefaultTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    protected void updateJarFileRefs() {
        CloneIterator xmlFileRefs = new CloneIterator(this.xmlPersistenceUnit.getJarFiles());
        ListIterator<JarFileRef> contextFileRefs = this.jarFileRefs();
        while (contextFileRefs.hasNext()) {
            JarFileRef contextFileRef = (JarFileRef)contextFileRefs.next();
            if (xmlFileRefs.hasNext()) {
                contextFileRef.update((XmlJarFileRef)xmlFileRefs.next());
                continue;
            }
            this.removeJarFileRef_(contextFileRef);
        }
        while (xmlFileRefs.hasNext()) {
            this.addJarFileRef_(this.buildJarFileRef((XmlJarFileRef)xmlFileRefs.next()));
        }
    }

    protected JarFileRef buildJarFileRef(XmlJarFileRef xmlJarFileRef) {
        return this.getJpaFactory().buildJarFileRef(this, xmlJarFileRef);
    }

    protected void updateSpecifiedClassRefs() {
        CloneIterator xmlClassRefs = new CloneIterator(this.xmlPersistenceUnit.getClasses());
        ListIterator<ClassRef> contextClassRefs = this.specifiedClassRefs();
        while (contextClassRefs.hasNext()) {
            ClassRef contextClassRef = (ClassRef)contextClassRefs.next();
            if (xmlClassRefs.hasNext()) {
                contextClassRef.update((XmlJavaClassRef)xmlClassRefs.next());
                continue;
            }
            this.removeSpecifiedClassRef_(contextClassRef);
        }
        while (xmlClassRefs.hasNext()) {
            this.addSpecifiedClassRef_(this.buildClassRef((XmlJavaClassRef)xmlClassRefs.next()));
        }
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getJpaFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    protected void updateMappingFileRefs() {
        CloneIterator xmlFileRefs = new CloneIterator(this.xmlPersistenceUnit.getMappingFiles());
        ListIterator<MappingFileRef> contextFileRefs = this.specifiedMappingFileRefs();
        while (contextFileRefs.hasNext()) {
            MappingFileRef contextFileRef = (MappingFileRef)contextFileRefs.next();
            if (xmlFileRefs.hasNext()) {
                contextFileRef.update((XmlMappingFileRef)xmlFileRefs.next());
                continue;
            }
            this.removeSpecifiedMappingFileRef_(contextFileRef);
        }
        while (xmlFileRefs.hasNext()) {
            this.addSpecifiedMappingFileRef_(this.buildSpecifiedMappingFileRef((XmlMappingFileRef)xmlFileRefs.next()));
        }
        if (this.impliedMappingFileIsSpecified()) {
            if (this.impliedMappingFileRef != null) {
                this.unsetImpliedMappingFileRef();
            }
        } else if (this.impliedMappingFileExists()) {
            if (this.impliedMappingFileRef == null) {
                this.setImpliedMappingFileRef();
            }
            this.impliedMappingFileRef.update(null);
        } else if (this.impliedMappingFileRef != null) {
            this.unsetImpliedMappingFileRef();
        }
    }

    protected MappingFileRef buildSpecifiedMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getJpaFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    protected boolean impliedMappingFileIsSpecified() {
        String impliedMappingFileName = "META-INF/orm.xml";
        ListIterator<MappingFileRef> stream = this.specifiedMappingFileRefs();
        while (stream.hasNext()) {
            if (!impliedMappingFileName.equals(((MappingFileRef)stream.next()).getFileName())) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        return this.getJpaProject().getDefaultOrmXmlResource() != null;
    }

    protected void updateImpliedClassRefs() {
        if (this.excludesUnlistedClasses()) {
            this.clearImpliedClassRefs_();
        } else {
            this.updateImpliedClassRefs_();
        }
    }

    protected void updateImpliedClassRefs_() {
        HashBag impliedRefsToRemove = CollectionTools.bag(this.impliedClassRefs(), (int)this.impliedClassRefsSize());
        ArrayList<ClassRef> impliedRefsToUpdate = new ArrayList<ClassRef>(this.impliedClassRefsSize());
        Iterator<String> annotatedClassNames = this.getJpaProject().annotatedClassNames();
        while (annotatedClassNames.hasNext()) {
            String annotatedClassName = annotatedClassNames.next();
            if (this.specifiesPersistentType(annotatedClassName)) continue;
            boolean match = false;
            Iterator classRefs = impliedRefsToRemove.iterator();
            while (classRefs.hasNext()) {
                ClassRef classRef = (ClassRef)classRefs.next();
                if (!annotatedClassName.equals(classRef.getClassName())) continue;
                classRefs.remove();
                impliedRefsToUpdate.add(classRef);
                match = true;
                break;
            }
            if (match) continue;
            this.addImpliedClassRef(annotatedClassName);
        }
        for (ClassRef classRef : impliedRefsToRemove) {
            this.removeImpliedClassRef(classRef);
        }
        for (ClassRef classRef : impliedRefsToUpdate) {
            classRef.update(classRef.getClassName());
        }
    }

    protected void clearImpliedClassRefs_() {
        Iterator<ClassRef> stream = this.impliedClassRefs();
        while (stream.hasNext()) {
            this.removeImpliedClassRef(stream.next());
        }
    }

    protected void updateProperties() {
        HashBag contextPropertiesToRemove = CollectionTools.bag(this.properties(), (int)this.propertiesSize());
        int resourceIndex = 0;
        Iterator<XmlProperty> xmlProperties = this.xmlProperties();
        while (xmlProperties.hasNext()) {
            XmlProperty xmlProperty = xmlProperties.next();
            boolean match = false;
            Iterator contextProperties = contextPropertiesToRemove.iterator();
            while (contextProperties.hasNext()) {
                PersistenceUnit.Property contextProperty = (PersistenceUnit.Property)contextProperties.next();
                if (contextProperty.getXmlProperty() != xmlProperty) continue;
                contextProperties.remove();
                this.moveProperty_(resourceIndex, contextProperty);
                contextProperty.update();
                match = true;
                break;
            }
            if (!match) {
                this.addProperty_(resourceIndex, this.buildProperty(xmlProperty));
            }
            ++resourceIndex;
        }
        for (PersistenceUnit.Property contextProperty : contextPropertiesToRemove) {
            this.removeProperty_(contextProperty);
        }
    }

    protected Iterator<XmlProperty> xmlProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties != null ? new CloneIterator(xmlProperties.getProperties()) : EmptyIterator.instance();
    }

    protected int xmlPropertiesSize() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties == null ? 0 : xmlProperties.getProperties().size();
    }

    protected void updatePersistenceUnitDefaults() {
        MappingFilePersistenceUnitDefaults defaults = this.getDefaults();
        this.setDefaultAccess(this.buildDefaultAccess(defaults));
        this.setDefaultCatalog(this.buildDefaultCatalog(defaults));
        this.setDefaultSchema(this.buildDefaultSchema(defaults));
        this.setDefaultCascadePersist(this.buildDefaultCascadePersist(defaults));
    }

    protected MappingFilePersistenceUnitDefaults getDefaults() {
        ListIterator<MappingFileRef> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)stream.next();
            if (!mappingFileRef.persistenceUnitDefaultsExists()) continue;
            return mappingFileRef.getPersistenceUnitDefaults();
        }
        return null;
    }

    protected AccessType buildDefaultAccess(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? null : defaults.getAccess();
    }

    protected String buildDefaultCatalog(MappingFilePersistenceUnitDefaults defaults) {
        String catalog = defaults == null ? null : defaults.getCatalog();
        return catalog != null ? catalog : this.getJpaProject().getDefaultCatalog();
    }

    protected String buildDefaultSchema(MappingFilePersistenceUnitDefaults defaults) {
        String schema = defaults == null ? null : defaults.getSchema();
        return schema != null ? schema : this.getJpaProject().getDefaultSchema();
    }

    protected boolean buildDefaultCascadePersist(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? false : defaults.isCascadePersist();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingFiles(messages, reporter);
        this.validateClassRefs(messages, reporter);
        this.validateJarFileRefs(messages, reporter);
    }

    protected void validateMappingFiles(List<IMessage> messages, IReporter reporter) {
        this.checkForMultiplePersistenceUnitDefaults(messages);
        this.checkForDuplicateMappingFiles(messages);
        ListIterator<MappingFileRef> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            ((MappingFileRef)stream.next()).validate(messages, reporter);
        }
    }

    protected void checkForMultiplePersistenceUnitDefaults(List<IMessage> messages) {
        ListIterator<MappingFileRef> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            if (((MappingFileRef)stream.next()).persistenceUnitDefaultsExists()) break;
        }
        while (stream.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)stream.next();
            if (!mappingFileRef.persistenceUnitDefaultsExists()) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_DEFAULTS", new String[]{mappingFileRef.getFileName()}, mappingFileRef));
        }
    }

    protected void checkForDuplicateMappingFiles(List<IMessage> messages) {
        HashBag fileNames = new HashBag();
        CollectionTools.addAll((Collection)fileNames, this.mappingFileRefNames());
        ListIterator<MappingFileRef> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)stream.next();
            String fileName = mappingFileRef.getFileName();
            if (fileNames.count((Object)fileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", new String[]{fileName}, mappingFileRef, mappingFileRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> mappingFileRefNames() {
        return new TransformationIterator<MappingFileRef, String>(this.mappingFileRefs()){

            protected String transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getFileName();
            }
        };
    }

    protected void validateClassRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateClasses(messages);
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            stream.next().validate(messages, reporter);
        }
    }

    protected void checkForDuplicateClasses(List<IMessage> messages) {
        HashBag classNames = new HashBag();
        CollectionTools.addAll((Collection)classNames, this.classRefNames());
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = stream.next();
            String className = classRef.getClassName();
            if (className == null || classNames.count((Object)className) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", new String[]{className}, classRef, classRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> classRefNames() {
        return new TransformationIterator<ClassRef, String>(this.classRefs()){

            protected String transform(ClassRef classRef) {
                return classRef.getClassName();
            }
        };
    }

    protected void validateJarFileRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateJarFileRefs(messages);
        for (JarFileRef each : CollectionTools.iterable(this.jarFileRefs())) {
            each.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateJarFileRefs(List<IMessage> messages) {
        HashBag jarFileNames = new HashBag();
        CollectionTools.addAll((Collection)jarFileNames, this.jarFileNames());
        for (JarFileRef jarFileRef : CollectionTools.iterable(this.jarFileRefs())) {
            String jarFileName = jarFileRef.getFileName();
            if (jarFileName == null || jarFileNames.count((Object)jarFileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_JAR_FILE", new String[]{jarFileName}, jarFileRef, jarFileRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> jarFileNames() {
        return new TransformationIterator<JarFileRef, String>(this.jarFileRefs()){

            protected String transform(JarFileRef jarFileRef) {
                return jarFileRef.getFileName();
            }
        };
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        Iterator<JpaStructureNode> stream = this.jarFileRefs();
        while (stream.hasNext()) {
            JarFileRef jarFileRef = (JarFileRef)stream.next();
            if (!jarFileRef.containsOffset(textOffset)) continue;
            return jarFileRef;
        }
        stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)stream.next();
            if (!mappingFileRef.containsOffset(textOffset)) continue;
            return mappingFileRef;
        }
        stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = (ClassRef)stream.next();
            if (!classRef.containsOffset(textOffset)) continue;
            return classRef;
        }
        return this;
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlPersistenceUnit.getValidationTextRange();
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        PersistentType persistentType;
        Iterator<JpaStructureNode> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            persistentType = ((MappingFileRef)stream.next()).getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = (ClassRef)stream.next();
            if (!classRef.isFor(typeName)) continue;
            return classRef.getJavaPersistentType();
        }
        stream = this.jarFileRefs();
        while (stream.hasNext()) {
            persistentType = ((JarFileRef)stream.next()).getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        return null;
    }

    @Override
    public boolean specifiesPersistentType(String className) {
        ListIterator<JpaStructureNode> stream = this.specifiedClassRefs();
        while (stream.hasNext()) {
            if (!className.equals(((ClassRef)stream.next()).getClassName())) continue;
            return true;
        }
        stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            if (((MappingFileRef)stream.next()).getPersistentType(className) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entity getEntity(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        if (persistentType == null) {
            return null;
        }
        TypeMapping typeMapping = persistentType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Embeddable getEmbeddable(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        if (persistentType == null) {
            return null;
        }
        TypeMapping typeMapping = persistentType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistenceUnit != null && this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }
}

