/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaRelationshipMapping;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaMultiRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaRelationshipMapping<T>
implements MultiRelationshipMapping {
    protected String orderBy;
    protected boolean isNoOrdering;
    protected boolean isPkOrdering;
    protected boolean isCustomOrdering;
    protected String mapKey;

    protected AbstractJavaMultiRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        if (newOrderBy == null) {
            if (this.getResourceOrderBy() != null) {
                this.removeResourceOrderBy();
            }
        } else {
            if (this.getResourceOrderBy() == null) {
                this.addResourceOrderBy();
            }
            this.getResourceOrderBy().setValue(newOrderBy);
        }
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    protected void setOrderBy_(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    protected OrderByAnnotation getResourceOrderBy() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation addResourceOrderBy() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("javax.persistence.OrderBy");
    }

    protected void removeResourceOrderBy() {
        this.getResourcePersistentAttribute().removeSupportingAnnotation("javax.persistence.OrderBy");
    }

    @Override
    public boolean isNoOrdering() {
        return this.isNoOrdering;
    }

    @Override
    public void setNoOrdering(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        if (newNoOrdering && this.getResourceOrderBy() != null) {
            this.removeResourceOrderBy();
        }
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    protected void setNoOrdering_(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.isPkOrdering;
    }

    @Override
    public void setPkOrdering(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        if (newPkOrdering) {
            if (this.getResourceOrderBy() == null) {
                this.addResourceOrderBy();
            } else {
                this.getResourceOrderBy().setValue(null);
            }
        }
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    protected void setPkOrdering_(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.isCustomOrdering;
    }

    @Override
    public void setCustomOrdering(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        if (newCustomOrdering) {
            this.setOrderBy("");
        }
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    protected void setCustomOrdering_(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    @Override
    public FetchType getDefaultFetch() {
        return MultiRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (oldMapKey != newMapKey) {
            if (this.getMapKeyResource() != null) {
                if (newMapKey != null) {
                    this.getMapKeyResource().setName(newMapKey);
                } else {
                    this.getResourcePersistentAttribute().removeSupportingAnnotation("javax.persistence.MapKey");
                }
            } else if (newMapKey != null) {
                this.getResourcePersistentAttribute().addSupportingAnnotation("javax.persistence.MapKey");
                this.getMapKeyResource().setName(newMapKey);
            }
        }
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    protected void setMapKey_(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    @Override
    protected String buildDefaultTargetEntity() {
        return this.getPersistentAttribute().getMultiReferenceEntityTypeName();
    }

    protected boolean mapKeyNameTouches(int pos, CompilationUnit astRoot) {
        if (this.getMapKeyResource() != null) {
            return this.getMapKeyResource().nameTouches(pos, astRoot);
        }
        return false;
    }

    protected MapKeyAnnotation getMapKeyResource() {
        return (MapKeyAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation("javax.persistence.MapKey");
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMapKeyNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMapKeyNames(), filter);
    }

    protected Iterator<String> javaCandidateMapKeyNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateMapKeyNames(filter));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mapKeyNameTouches(pos, astRoot)) {
            return this.javaCandidateMapKeyNames(filter);
        }
        return null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyResource();
        if (mapKeyAnnotation != null) {
            this.mapKey = mapKeyAnnotation.getName();
        }
        this.initializeOrderBy();
    }

    protected void initializeOrderBy() {
        OrderByAnnotation orderByAnnotation = this.getResourceOrderBy();
        if (orderByAnnotation != null) {
            this.orderBy = orderByAnnotation.getValue();
            if (orderByAnnotation.getValue() == null) {
                this.isPkOrdering = true;
            } else {
                this.isCustomOrdering = true;
            }
        } else {
            this.isNoOrdering = true;
        }
    }

    @Override
    protected void update() {
        super.update();
        this.updateMapKey();
        this.updateOrderBy();
    }

    protected void updateMapKey() {
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyResource();
        if (mapKeyAnnotation != null) {
            this.setMapKey_(mapKeyAnnotation.getName());
        } else {
            this.setMapKey_(null);
        }
    }

    protected void updateOrderBy() {
        OrderByAnnotation orderByAnnotation = this.getResourceOrderBy();
        if (orderByAnnotation != null) {
            this.setOrderBy_(orderByAnnotation.getValue());
            if (orderByAnnotation.getValue() == null) {
                this.setPkOrdering_(true);
                this.setCustomOrdering_(false);
                this.setNoOrdering_(false);
            } else {
                this.setPkOrdering_(false);
                this.setCustomOrdering_(true);
                this.setNoOrdering_(false);
            }
        } else {
            this.setOrderBy_(null);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setNoOrdering_(true);
        }
    }
}

