/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.configurationadmin;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.configurationadmin.ConfigurationArtifact;
import org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListener;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelConfigurationListenerInitializer {
    private final Logger logger;
    private final ServiceRegistrationTracker registrationTracker;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final ConfigurationAdmin configurationAdmin;
    private final Region globalRegion;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ModelConfigurationListenerInitializer(@NonNull RuntimeArtifactRepository artifactRepository, @NonNull BundleContext bundleContext, @NonNull ConfigurationAdmin configurationAdmin, @NonNull Region globalRegion) {
        Region region = globalRegion;
        ConfigurationAdmin configurationAdmin2 = configurationAdmin;
        BundleContext bundleContext2 = bundleContext;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)configurationAdmin2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.registrationTracker = new ServiceRegistrationTracker();
            this.artifactRepository = artifactRepository;
            this.bundleContext = bundleContext;
            this.configurationAdmin = configurationAdmin;
            this.globalRegion = globalRegion;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @PostConstruct
    public void initialize() throws IOException, InvalidSyntaxException {
        try {
            block7: {
                ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    ModelConfigurationListener configurationListener = new ModelConfigurationListener(this.artifactRepository, this.bundleContext, this.configurationAdmin, this.globalRegion);
                    this.registrationTracker.track(this.bundleContext.registerService(ConfigurationListener.class.getCanonicalName(), (Object)configurationListener, null));
                    Configuration[] configurations = this.configurationAdmin.listConfigurations(null);
                    if (configurations == null) break block7;
                    Configuration[] configurationArray = configurations;
                    int n = configurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Configuration configuration = configurationArray[n2];
                        try {
                            this.artifactRepository.add(new ConfigurationArtifact(this.bundleContext, this.configurationAdmin, configuration.getPid(), this.globalRegion));
                        }
                        catch (Exception e) {
                            this.logger.error(String.format("Exception adding configuration '%s' to the repository", configuration.getPid()), (Throwable)e);
                        }
                        ++n2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }
            ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                this.registrationTracker.unregisterAll();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ModelConfigurationListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ModelConfigurationListenerInitializer.java", Class.forName("org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListenerInitializer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListenerInitializer", "", "", "java.io.IOException:org.osgi.framework.InvalidSyntaxException:", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListenerInitializer", "", "", "", "void"), 91);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListenerInitializer");
    }
}

