/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.virgo.ide.manifest.core.editor.model.SpringBundleModel;
import org.eclipse.virgo.ide.ui.editors.PdeCompatibilityUtil;

public class SpringBundleInputContext
extends BundleInputContext {
    public SpringBundleInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        SpringBundleModel model = null;
        boolean isReconciling = input instanceof IFileEditorInput;
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        model = new SpringBundleModel(document, isReconciling);
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            model.setUnderlyingResource((IResource)file);
            model.setCharset(file.getCharset());
        } else if (PdeCompatibilityUtil.isSystemFileEditorInput(input)) {
            File file = (File)input.getAdapter(File.class);
            IPath path = new Path(file.getAbsolutePath()).removeLastSegments(2);
            model.setInstallLocation(path.addTrailingSeparator().toString());
            model.setCharset(this.getDefaultCharset());
        } else if (input instanceof IURIEditorInput) {
            IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            model.setInstallLocation(store.getParent().getParent().toString());
            model.setCharset(this.getDefaultCharset());
        } else if (input instanceof JarEntryEditorInput) {
            File file = (File)((JarEntryEditorInput)input).getAdapter(File.class);
            model.setInstallLocation(file.toString());
            model.setCharset(this.getDefaultCharset());
        } else {
            model.setCharset(this.getDefaultCharset());
        }
        model.load();
        return model;
    }
}

