/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.virgo.ide.runtime.core.artefacts.Artefact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEditorUtils {
    public static void removeOldVersions(Set<Artefact> bundles) {
        HashMap<String, Artefact> symbolicNameToHighestVersionMap = new HashMap<String, Artefact>(bundles.size());
        HashSet<Artefact> oldArtifacts = new HashSet<Artefact>();
        for (Artefact currArtifactDefinition : bundles) {
            Artefact mappedArtifact = (Artefact)symbolicNameToHighestVersionMap.get(currArtifactDefinition.getSymbolicName());
            if (mappedArtifact == null) {
                symbolicNameToHighestVersionMap.put(currArtifactDefinition.getSymbolicName(), currArtifactDefinition);
                continue;
            }
            if (currArtifactDefinition.getVersion().compareTo(mappedArtifact.getVersion()) <= 0) {
                oldArtifacts.add(currArtifactDefinition);
                continue;
            }
            oldArtifacts.add(mappedArtifact);
            symbolicNameToHighestVersionMap.put(currArtifactDefinition.getSymbolicName(), currArtifactDefinition);
        }
        bundles.removeAll(oldArtifacts);
    }

    public static boolean hasErrorSeverityMarker(IMarker[] markers) throws CoreException {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker currMarker = iMarkerArray[n2];
            Integer severity = (Integer)currMarker.getAttribute("severity");
            if (severity != null && severity == 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

