/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEProjectionSourcePage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.pde.internal.ui.editor.text.BundleHyperlink;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.virgo.ide.ui.internal.actions.ManifestFormatAction;

public class AbstractPdeFormTextEditorContributor
extends PDEFormEditorContributor {
    protected RetargetTextEditorAction fCorrectionAssist;
    protected HyperlinkAction fHyperlinkAction;
    protected ManifestFormatAction fFormatAction;
    protected RetargetTextEditorAction fContentAssist;
    protected final TextEditorActionContributor fSourceContributor = this.createSourceContributor();
    protected SubActionBars fSourceActionBars;

    public AbstractPdeFormTextEditorContributor(String menuName) {
        super(menuName);
        if (this.supportsCorrectionAssist()) {
            this.fCorrectionAssist = new RetargetTextEditorAction(PDESourcePage.getBundleForConstructedKeys(), "CorrectionAssistProposal.");
            this.fCorrectionAssist.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        if (this.supportsHyperlinking()) {
            this.fHyperlinkAction = new SpringHyperlinkAction();
            this.fHyperlinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        }
        if (this.supportsFormatAction()) {
            this.fFormatAction = new ManifestFormatAction();
            this.fFormatAction.setActionDefinitionId("org.eclipse.pde.ui.edit.text.format");
        }
        if (this.supportsContentAssist()) {
            this.fContentAssist = new RetargetTextEditorAction(PDESourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.");
            this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
    }

    public boolean supportsCorrectionAssist() {
        return false;
    }

    public boolean supportsContentAssist() {
        return false;
    }

    public boolean supportsFormatAction() {
        return false;
    }

    public boolean supportsHyperlinking() {
        return false;
    }

    public IEditorActionBarContributor getSourceContributor() {
        return this.fSourceContributor;
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.fSourceActionBars = new SubActionBars(bars);
        this.fSourceContributor.init((IActionBars)this.fSourceActionBars);
    }

    public void dispose() {
        this.fSourceActionBars.dispose();
        this.fSourceContributor.dispose();
        super.dispose();
    }

    protected void setSourceActionBarsActive(boolean active) {
        IActionBars rootBars = this.getActionBars();
        rootBars.clearGlobalActionHandlers();
        rootBars.updateActionBars();
        if (active) {
            this.fSourceActionBars.activate();
            Map handlers = this.fSourceActionBars.getGlobalActionHandlers();
            if (handlers != null) {
                Set keys = handlers.keySet();
                for (String id : keys) {
                    rootBars.setGlobalActionHandler(id, (IAction)handlers.get(id));
                }
            }
        } else {
            this.fSourceActionBars.deactivate();
            this.registerGlobalActionHandlers();
        }
        rootBars.setGlobalActionHandler("org.eclipse.pde.ui.actions.Open", (IAction)(active ? this.fHyperlinkAction : null));
        rootBars.setGlobalActionHandler("org.eclipse.pde.ui.actions.Format", (IAction)(active ? this.fFormatAction : null));
        rootBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.getRevertAction());
        rootBars.updateActionBars();
    }

    protected void registerGlobalActionHandlers() {
        this.registerGlobalAction(ActionFactory.DELETE.getId());
        this.registerGlobalAction(ActionFactory.UNDO.getId());
        this.registerGlobalAction(ActionFactory.REDO.getId());
        this.registerGlobalAction(ActionFactory.CUT.getId());
        this.registerGlobalAction(ActionFactory.COPY.getId());
        this.registerGlobalAction(ActionFactory.PASTE.getId());
        this.registerGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.registerGlobalAction(ActionFactory.FIND.getId());
    }

    protected void registerGlobalAction(String id) {
        IAction action = this.getGlobalAction(id);
        this.getActionBars().setGlobalActionHandler(id, action);
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.fEditor == null) {
            return;
        }
        IFormPage oldPage = this.fPage;
        this.fPage = this.fEditor.getActivePageInstance();
        if (this.fPage == null) {
            return;
        }
        this.updateQuickOutlineMenuEntry();
        this.updateActions();
        if (oldPage != null && !oldPage.isEditor() && !this.fPage.isEditor()) {
            this.getActionBars().updateActionBars();
            return;
        }
        boolean isSourcePage = this.fPage instanceof PDESourcePage;
        if (isSourcePage && this.fPage.equals(oldPage)) {
            return;
        }
        this.fSourceContributor.setActiveEditor((IEditorPart)this.fPage);
        this.setSourceActionBarsActive(isSourcePage);
    }

    protected void updateQuickOutlineMenuEntry() {
        IActionBars actionBars = this.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        IMenuManager navigateMenu = menuManager.findMenuUsingPath("navigate");
        if (navigateMenu == null) {
            return;
        }
        navigateMenu.remove("org.eclipse.pde.ui.quickOutline");
        if (!(this.fPage instanceof PDEProjectionSourcePage)) {
            return;
        }
        PDEProjectionSourcePage page = (PDEProjectionSourcePage)this.fPage;
        if (!page.isQuickOutlineEnabled()) {
            return;
        }
        IAction quickOutlineAction = page.getAction("org.eclipse.pde.ui.quickOutline");
        if (quickOutlineAction == null) {
            return;
        }
        try {
            navigateMenu.insertAfter("showIn", quickOutlineAction);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected TextEditorActionContributor createSourceContributor() {
        return new PDETextEditorActionContributor();
    }

    protected HyperlinkAction getHyperlinkAction() {
        return this.fHyperlinkAction;
    }

    protected ManifestFormatAction getFormatAction() {
        return this.fFormatAction;
    }

    protected class PDETextEditorActionContributor
    extends TextEditorActionContributor {
        protected PDETextEditorActionContributor() {
        }

        public void contributeToMenu(IMenuManager mm) {
            super.contributeToMenu(mm);
            IMenuManager editMenu = mm.findMenuUsingPath("edit");
            if (editMenu != null) {
                editMenu.add((IContributionItem)new Separator("group.open"));
                editMenu.add((IContributionItem)new Separator("group.generate"));
                editMenu.add((IContributionItem)new Separator("additions"));
                if (AbstractPdeFormTextEditorContributor.this.fCorrectionAssist != null) {
                    editMenu.appendToGroup("group.generate", (IAction)AbstractPdeFormTextEditorContributor.this.fCorrectionAssist);
                }
                if (AbstractPdeFormTextEditorContributor.this.fContentAssist != null) {
                    editMenu.appendToGroup("group.generate", (IAction)AbstractPdeFormTextEditorContributor.this.fContentAssist);
                }
            }
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            super.contributeToToolBar(toolBarManager);
            if (AbstractPdeFormTextEditorContributor.this.fHyperlinkAction != null) {
                toolBarManager.add((IAction)AbstractPdeFormTextEditorContributor.this.fHyperlinkAction);
            }
        }

        public void setActiveEditor(IEditorPart part) {
            ITextEditor textEditor;
            super.setActiveEditor(part);
            IActionBars actionBars = this.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(null);
            manager.setErrorMessage(null);
            ITextEditor iTextEditor = textEditor = part instanceof ITextEditor ? (ITextEditor)part : null;
            if (AbstractPdeFormTextEditorContributor.this.fCorrectionAssist != null) {
                AbstractPdeFormTextEditorContributor.this.fCorrectionAssist.setAction(this.getAction(textEditor, "QuickAssist"));
            }
            if (AbstractPdeFormTextEditorContributor.this.fHyperlinkAction != null) {
                AbstractPdeFormTextEditorContributor.this.fHyperlinkAction.setTextEditor(textEditor);
            }
            if (AbstractPdeFormTextEditorContributor.this.fFormatAction != null) {
                AbstractPdeFormTextEditorContributor.this.fFormatAction.setTextEditor(textEditor);
            }
            if (AbstractPdeFormTextEditorContributor.this.fContentAssist != null) {
                AbstractPdeFormTextEditorContributor.this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssist"));
            }
        }
    }

    class SpringHyperlinkAction
    extends HyperlinkAction {
        SpringHyperlinkAction() {
        }

        public void generateActionText() {
            String text = PDEUIMessages.HyperlinkActionNoLinksAvailable;
            if (this.fLink instanceof BundleHyperlink) {
                text = PDEUIMessages.HyperlinkActionOpenPackage;
                this.setText(text);
                this.setToolTipText(text);
            } else {
                super.generateActionText();
            }
        }
    }
}

